"""
Provide asyncio hook
"""
import asyncio
import hooks

def asyncio_evaluator(hook, context):
    if len(hook.functions) == 0:
        return
    for function in hook.functions:
        if function.enabled:
            asyncio.async(asyncio.coroutine(function.function)(context))
    while True:
        remaining = [ t for t in asyncio.Task.all_tasks()
                      if not (t.cancelled() or t.done()) ]
        if remaining:
            asyncio.get_event_loop().run_until_complete(asyncio.wait(remaining))
        else:
            return

async = hooks.new("asyncio",
                  "The functions in this hook must not be blocking.\n"
                  "They must use the asyncio library.",
                  evaluator=asyncio_evaluator,
                  args=("context",))

hooks.add_to("action", async, after="fy_thread")

@hooks.add_to("help")
def help(dummy_context, messages):
    messages.append(
        "\n"
        "Asyncio functions:"
        )
