#include <stdio.h>
#include "utc_time.h"

utc_time time_from_julian(julian)
double julian;
{
	int j, leap;
	int year, month, day, hour, minute;

	double second;

	utc_time Time;

	Time.julian = julian;
	Time.mjd = Time.julian - 2400000.5;
	Time.sec85 = (Time.julian - gregorian_to_julian(1985,1,1,0,0,0))*86400.0;

	julian_to_gregorian(&year,&month,&day,&hour,&minute,&second,julian);

	Time.year = year;
	Time.month = month;
	Time.day = day;
	Time.hour = hour;
	Time.minute = minute;
	Time.second = second;

	Time.decimal_day = (double)hour / 24.0 + (double)minute / 1440.0 + second / 86400.0;

	if (Time.decimal_day >= 0.5) strcpy(Time.ampm,"PM");
	else strcpy(Time.ampm,"AM");

	if (Time.year >= 0) strcpy(Time.adbc,"AD");
	else strcpy(Time.adbc,"BC");

	strcpy(Time.monthname,months[month-1]);
	strcpy(Time.smonth,short_months[month-1]);
	strcpy(Time.weekday,days[(int)(Time.julian+1.5)%7]);

	j = (int)(Time.julian - 2444244.5);
	Time.gweek[0] = j/7;
	Time.gweek[1] = j%7;

	leap = year%4 == 0 && year%100 != 0 || year%400 == 0;
	Time.doy = mth[leap][month-1] + day;

	Time.date = (double)Time.year + (double)(Time.doy - 1) / (365.0 + (double)leap) +
		Time.decimal_day / (365.0 + (double)leap);

	Time.j2000 = (Time.julian - 2451545.0) / 36525.0;

	return Time;
				
}
