#include <stdio.h>
#include "utc_time.h"

utc_time time_from_doy_gregorian(year,doy,hour,minute,second)
int year, doy, hour, minute;
double second;
{
	int j, leap, month, day;

	utc_time Time;

	Time.year = year;
	Time.doy = doy;

	leap = year%4 == 0 && year%100 != 0 || year%400 == 0;

	month = 0;
	for (j = 0; j < 12; j++) {
		if (mth[leap][j] >= doy) {
			month = j;
			break;
		}
	}
	if (month == 0) month = 12;

	day = doy - mth[leap][month-1];
 
	Time.month = month;
	Time.day = day;
	Time.hour = hour;
	Time.minute = minute;
	Time.second = second;

	Time.decimal_day = (double)hour / 24.0 + (double)minute / 1440.0 + second / 86400.0;
	Time.julian = gregorian_to_julian(year,month,day,hour,minute,second);
	Time.mjd = Time.julian - 2400000.5;
	Time.sec85 = (Time.julian - gregorian_to_julian(1985,01,01,00,00,00))*86400.0;

	if (Time.decimal_day >= 0.5) strcpy(Time.ampm,"PM");
	else strcpy(Time.ampm,"AM");

	if (Time.year >= 0) strcpy(Time.adbc,"AD");
	else strcpy(Time.adbc,"BC");

	strcpy(Time.monthname,months[month-1]);
	strcpy(Time.smonth,short_months[month-1]);
	strcpy(Time.weekday,days[(int)(Time.julian+1.5)%7]);

	j = (int)(Time.julian - 2444244.5);
	Time.gweek[0] = j/7;
	Time.gweek[1] = j%7;


	Time.date = (double)Time.year + (double)(Time.doy - 1) / (365.0 + (double)leap) + 
			Time.decimal_day / (365.0 + (double)leap);

	Time.j2000 = (Time.julian - 2451545.0) / 36525.0;

	return Time;
				
}
