#include <stdio.h>
#include <math.h>
#include "utc_time.h"

utc_time thisDecade(utc_time time)
{

double year;

utc_time t;

year = floor((double)time.year / 10.0) * 10.0;

t = time_from_gregorian((int)year,1,1,0,0,0.0);

return(t);

}

utc_time thisYear(utc_time time)
{

/*
 * Date manipulation function. Returns the date (in utc_time structure) for the
 * beginning of the year of the given time represented as a utc_time value.
 */

utc_time t;

t = time_from_gregorian(time.year,1,1,0,0,0.0); 

return(t);

}

utc_time thisMonth(utc_time time)
{

utc_time t;

t = time_from_gregorian(time.year,time.month,1,0,0,0.0);

return(t);

}

utc_time thisDay(utc_time time)
{

utc_time t;

t = time_from_gregorian(time.year,time.month,time.day,0,0,0.0);

return(t);

}

utc_time today(utc_time time)
{

utc_time t;

t = time_from_gregorian(time.year,time.month,time.day,0,0,0.0);

return(t);

}


utc_time thisHour(utc_time time)
{

utc_time t;

t = time_from_gregorian(time.year,time.month,time.day,time.hour,0,0.0);

return(t);

}

utc_time thisMinute(utc_time time)
{

utc_time t;

t = time_from_gregorian(time.year,time.month,time.day,time.hour,time.minute,0.0);

return(t);

}

utc_time thisSecond(utc_time time)
{

double second;

utc_time t;

second = floor(time.second);

t = time_from_gregorian(time.year,time.month,time.day,time.hour,time.minute,second);

return(t);

}

utc_time thisWeek(utc_time time)
{

double julian;

utc_time t;

julian = time.gweek[0] * 7 + 2444244.5;

t = time_from_julian(julian);

return(t);

}

utc_time nextDecade(utc_time time)
{

double year;

utc_time t;

year = ceil((double)(time.year+1) / 10.0) * 10.0;

t = time_from_gregorian((int)year,1,1,0,0,0.0);

return(t);

}

utc_time nextYear(utc_time time)
{

int year;

utc_time t;

year = time.year + 1;
t = time_from_gregorian(year,1,1,0,0,0.0);

return(t);

}

utc_time nextMonth(utc_time time)
{

int year, month;

utc_time t;

year = time.year;
month = time.month + 1;
if (month == 12) {
	month = 1;
	year++;
}

t = time_from_gregorian(year,month,1,0,0,0.0);

return(t);

}

utc_time nextWeek(utc_time time)
{

double julian;

utc_time t;

julian = (time.gweek[0] + 1) * 7 + 2444244.5;

t = time_from_julian(julian);

return(t);

}

utc_time nextDay(utc_time time)
{

double julian;

utc_time t1, t2;

julian = time.julian;
julian += 1.0;

t1 = time_from_julian(julian);

t2 = today(t1);

return(t2);

}

utc_time tomorrow(utc_time time)
{

double julian;

utc_time t;

julian = time.julian;
julian += 1.0;

t = time_from_julian(julian);

t = today(t);

return(t);

}

utc_time yesterday(utc_time time)
{

double julian;

utc_time t;

julian = time.julian;
julian -= 1.0;

t = time_from_julian(julian);

t = today(t);

return(t);

}

utc_time lastYear(utc_time time)
{

int year;

utc_time t;

year = time.year - 1;
t = time_from_gregorian(year,1,1,0,0,0.0);

return(t);

}

utc_time lastMonth(utc_time time)
{

int year, month;

utc_time t;

year = time.year;
month = time.month - 1;
if (month == 0) {
	month = 12;
	year--;
}

t = time_from_gregorian(year,month,1,0,0,0.0);

return(t);

}

utc_time lastWeek(utc_time time)
{

double julian;

utc_time t;

julian = (time.gweek[0] - 1) * 7 + 2444244.5;

t = time_from_julian(julian);

return(t);

}

utc_time lastDay(utc_time time)
{

double julian;

utc_time t;

julian = time.julian;
julian -= 1.0;

t = time_from_julian(julian);

t = today(t);

return(t);

}

utc_time nextHour(utc_time time)
{

double julian;

utc_time t;

t = thisHour(time);

julian = t.julian;
/***************************************/
/* this ensures we reach the next hour */
/***************************************/
julian += (1.5 / 24.0);

t = time_from_julian(julian);

t = thisHour(t);

return(t);

}

utc_time nextMinute(utc_time time)
{

double julian;

utc_time t;

t = thisMinute(time);

julian = t.julian;
/*****************************************/
/* this ensures we reach the next minute */
/*****************************************/
julian += (1.5 / 1440.0);

t = time_from_julian(julian);

t = thisMinute(t);

return(t);

}

utc_time nextSecond(utc_time time)
{

double julian;

utc_time t;

t = thisSecond(time);

julian = t.julian;
/*****************************************/
/* this ensures we reach the next second */
/*****************************************/
julian += (1.5 / 86400.0);

t = time_from_julian(julian);

t = thisSecond(t);

return(t);

}


utc_time lastHour(utc_time time)
{

double julian;

utc_time t;

t = thisHour(time);

julian = t.julian;
/***************************************/
/* this ensures we reach the next hour */
/***************************************/
julian -= (0.5 / 24.0);

t = time_from_julian(julian);

t = thisHour(t);

return(t);

}

utc_time lastMinute(utc_time time)
{

double julian;

utc_time t;

t = thisMinute(time);

julian = t.julian;
/*****************************************/
/* this ensures we reach the next minute */
/*****************************************/
julian -= (0.5 / 1440.0);

t = time_from_julian(julian);

t = thisMinute(t);

return(t);

}

utc_time lastSecond(utc_time time)
{

double julian;

utc_time t;

t = thisSecond(time);

julian = t.julian;
/*****************************************/
/* this ensures we reach the next second */
/*****************************************/
julian -= (0.5 / 86400.0);

t = time_from_julian(julian);

t = thisSecond(t);

return(t);

}

utc_time addDays(utc_time time,int days)
{

double julian;

utc_time t;

t = today(time);

julian = t.julian;
/***************************************/
/* this ensures we reach the next hour */
/***************************************/
julian += ((double) days + 0.5);

t = time_from_julian(julian);

t = today(t);

return(t);

}

utc_time addWeeks(utc_time time, int weeks)
{

double julian;

utc_time t;

julian = (time.gweek[0] + weeks) * 7 + 2444244.5;

t = time_from_julian(julian);

return(t);

}

utc_time addMonths(utc_time time, int months)
{

int i, year, month;

utc_time t;

year = time.year;
month = time.month;

for (i = 0; i < months; i++) {
	month++;
	if (month == 12) {
		month = 1;
		year++;
	}
}

t = time_from_gregorian(year,month,1,0,0,0.0);

return(t);

}


utc_time addYears(utc_time time, int years)
{

int year;

utc_time t;

year = time.year + years;
t = time_from_gregorian(year,1,1,0,0,0.0);

return(t);

}

utc_time addHours(utc_time time, int hours)
{

double julian;

utc_time t;

t = thisHour(time);

julian = t.julian;
/***************************************/
/* this ensures we reach the next hour */
/***************************************/
julian += (((double) hours + 0.5) / 24.0);

t = time_from_julian(julian);

t = thisHour(t);

return(t);

}
