#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>
#include <errno.h>
#include "utc_time.h"

void julian_to_gregorian(year,month,day,hour,minute,second,julian)
int *year, *month, *day, *hour, *minute;
double *second, julian;
{

	int n, i, j, k, l, d;
	int day_sec;

	long jd;

	double decimal_day, time_offset, s, t;

	jd = (int)(julian+0.5);
	time_offset = julian - jd + 0.5;

	l = jd + 68569;
	n = (4*l) / 146097;
	l -= (146097 * n + 3) / 4;
	i = (4000 * (l + 1)) / 1461001;
	l = l -  (1461 * i) / 4 + 31;
	j = (80 * l) / 2447;
	d = l - (2447 * j) / 80;
	l = j / 11;
	(*month) = j + 2 - (12 * l);
	(*year) = 100 * (n - 49) + i + l;
	(*day) = d;
	
	s = time_offset * 86400.0;
	s += SMALL_TIME;
	(*hour) = (int)s/60/60;
	s -= (*hour) * 3600.0;
	(*minute) = (int)s/60;
	s -= (*minute) * 60;
	(*second) = s;
	
	/* just perform a quick check on this as floating point errors can confuse it */

	t = (double) (*hour) * 3600.0 + (double) (*minute) * 60.0 + (*second);
	s = time_offset * 86400.0;

	if (fabs(s-t) > 1e-6) {
		fprintf(stderr, " ERROR : julian_to_gregorian : hours, minutes and seconds do not add\n");
		fprintf(stderr, " %f %d %d %f %f\n", s, (*hour), (*minute), (*second), t);
		fprintf(stderr, " Please check this routine : julian = %.10f\n", julian);
		exit(EXIT_FAILURE); 
	}
}
