#include "timeseries.h"

void sort_params_to_models(noise_model *nm, int n_models, double *params, int n_params, int end_flag) {

int j, k, l;

for (l = 0, j = 0; j < n_models; j++) {
	for (k = 0; k < nm[j].n_pvec; k++) {
		if (nm[j].pvec_flag[k] == 0) {
			switch (nm[j].model) {
				case 'g':
					if (k == 0) nm[j].pvec[k] = pow(10.0,params[l++]);
					else nm[j].pvec[k] = params[l++];
					break;
				case 'f':
					nm[j].pvec[k] = pow(10.0,params[l++]);
					break;
				case 'b':
					nm[j].pvec[k] = params[l++];
					break;
				case 'p':
					nm[j].pvec[k] = params[l++];
					break;
				case 's':
					nm[j].pvec[k] = params[l++];
					break;
				case 't':
					nm[j].pvec[k] = params[l++];
					break;
			}
			if (end_flag == 1) {
				nm[j].pvec_flag[k] = 2;
			}
		}
	}
}

if (l != n_params) {
	fprintf(stderr, " Error : sort_params_to_models : mismatch between ");
	fprintf(stderr, " expected (%d) and actual (%d) ", n_params, l);
	fprintf(stderr, " number of parameters\n");
	exit(EXIT_FAILURE);
}

}
