#include "timeseries.h"

int sort_offsets(time_series ts, int component, int *time_index) {

        int l, k, n, index, j;
        int same_point;
        int used = 0;

	int *bf;

        double mintime, maxtime;

	bf = (int *) calloc((size_t) ts.n_series, sizeof(int) );

	for (j = 0; j < ts.n_series; j++) {
		n = lrint(pow(2.0,(double) j));
		bf[ts.n_series-j-1] = n; 
	}

        if (ts.n_offsets == 0) {
		free(bf);
		return (0);
	}

        mintime =  ts.t[0];
        maxtime =  ts.t[0];

        for (k = 0; k < ts.n_data; k++) {
                mintime = ts.t[k] < mintime ? ts.t[k] : mintime;
                maxtime = ts.t[k] > maxtime ? ts.t[k] : maxtime;
        }


        j = 0;
        for (k = 0; k < ts.n_offsets; k++) {
                if (ts.offsets[k] < mintime || ts.offsets[k] > maxtime) continue;
                if (ts.off_code[k] == 0) continue;
                if ((ts.off_code[k] & bf[component]) == 0) continue;
                for (n = 0; n < ts.n_data; n++) {
                        if (ts.offsets[k] > ts.t[n]) continue;
                        index = n;
                        break;
                }
                if (j == 0) {
                        time_index[j] = index;
                        j++;
                } else {
                        same_point = 0;
                        for (l = 0; l < j; l++) {
                                if (index == time_index[l]) {
                                        same_point = 1;
                                }
                        }
                        if (!same_point) {
                                time_index[j] = index;
                                j++;
                        }
                }
        }

	free(bf);
        return(j);
}
 
