#include "timeseries.h"

void fogm_tv(double *tv, int n, double beta, double dt) {

	int j;

	double sec_per_year, fs, Beta, a;

        sec_per_year = 365.24219*24.0*3600.0;

	Beta = beta / sec_per_year;

	fs = 1.0 / dt / sec_per_year;

	a = exp(-Beta / fs) * sqrt(dt) + exp(-fs/Beta) /  Beta * sqrt(fs/sec_per_year);

	for (j = 0; j < n; j++) {
		tv[j] = a * exp(-Beta * sec_per_year * (double) j * dt);
	}

}
