#!/bin/csh
# add the names of the stations for which you estimated a coseismic offset
set names = 'PMEJ JRGN'
# kind of noise used in the modelling
set noise = 'w'
# model made from raw or clean time-series
set base = 'raw'


gmtset BASEMAP_TYPE plain
gmtset D_FORMAT  %lg
gmtset ANOT_FONT_SIZE 8
gmtset LABEL_FONT_SIZE 10
gmtset TICK_LENGTH -0.2c

set r = '-R-72/-68/-26/-20'
set j = '-Jx3d'
set b = '-Ba2f1eWNs'
set out = 'map.ps'
set Se = -Se0.008
set A = -A0.06/0.25/0.1
makecpt -Cpolar -Z -T-500/500/0.01 > vert.cpt

psbasemap $r $j $b -K -P > $out
pscoast -O -K $r $j -Di -S100/100/250 -G150/150/150 >> $out
pscoast -O -K $r $j -Di -W2.5/0 >> $out
psxy ../sources/falla-10-48.txt $r $j -Sf0.8i/0.06ilt -W5/200/200/200 -G0/0/0 -V -K -O >> $out

foreach nam ($names)
set velh = `grep OFFSET ./mle/$nam.$base.$noise.mle | awk '{printf $0" "}' | cl 10 4 12 6 `
set velv = `grep OFFSET ./mle/$nam.$base.$noise.mle | awk '{printf $0" "}' | cl 16 `
set coord = `cl 1 2 ./vel/$nam.$base.$noise.vel`
echo $coord $velh | psvelo -O -K $r $j $A $Se/0/0 -G0 >> $out
echo $coord $velv | psxy $r $j -Sc0.3  -Cvert.cpt -W4/0 -O -K >> $out

end


psxy $r $j -Gwhite -Wthick/0/0/0 -V -K -O << EOF >> $out
288 -20    
288 -20     
288 -21.2    
289.5 -21.2
289.5 -20
EOF

echo  '288.3 -20.2 10 0 0 0 10 cm ' |\
pstext  $r $j  -G0/0/0 -O -K  >>  $out
echo  '288.5 -20.3 100 0 2 2 ' |\
psvelo  $r $j $Se/0.50/7 $A  -W1/0 -G0/0/0 -O -K  >>  $out
set TICK_PEN = 0.4p
set paletteXY = ( -D1.8/6i/2.8/0.6h -A -B200::/:"vert": )
psscale -Cvert.cpt $paletteXY -O -K >> $out

display $out
