
//! \file tuto3GL.glsl affichage d'un cube, 12 triangles, 36 sommets
#version 330

#ifdef VERTEX_SHADER

uniform vec3 positions[36];

uniform mat4 mvpMatrix;
uniform mat4 normalMatrix;
uniform float time;

out vec3 vertex_normal;
void main( )
{
    vec3 a= positions[gl_VertexID - gl_VertexID % 3];
    vec3 b= positions[gl_VertexID - gl_VertexID % 3 +1];
    vec3 c= positions[gl_VertexID - gl_VertexID % 3 +2];
    vec3 ab= normalize(b - a);
    vec3 ac= normalize(c - a);
    vec3 n= cross(ab, ac);
    vertex_normal= vec3(normalMatrix * vec4(n, 0));
    gl_Position= mvpMatrix * vec4(positions[gl_VertexID], 1);
}
#endif


#ifdef FRAGMENT_SHADER

in vec3 vertex_normal;

out vec4 fragment_color;

void main( )
{
    float face_id= float(gl_PrimitiveID /2) / 5.0;
    //~ vec3 color= vec3(face_id, 1 - face_id , 0);
    vec3 color= abs(normalize(vertex_normal)).zzz;
    // remplir le triangle avec une couleur uniforme
    fragment_color= vec4(color, 1);
    //~ fragment_color= vec4(abs(normalize(vertex_normal)), 1);
}
#endif
