
#ifndef RAY_H
#define RAY_H

#include <cfloat>

#include "vec.h"
#include "color.h"


//! representation d'un rayon.
struct Ray
{
    Ray( ) : origin(), direction() {}
    Ray( const Point& o, const Point& e ) : origin(o), direction( normalize(Vector(o, e)) ) {}

    Point origin;
    Vector direction;
};

//! construit un rayon avec o comme origine et e comme extremite, la direction est normalizee.
Ray make_ray( const Point& o, const Point& e );

//! construit le rayon reflechi dans la direction miroir au point p. 
Ray reflect( const Ray& ray, const Point& p, const Vector& normal );

float fresnel( const Ray& ray, const Point& p, const Vector& n, const float ir );

bool fresnel_refract( const Ray& ray, const Point& p, const Vector& n, const float ir );
Ray refract( const Ray& ray, const Point& p, const Vector& n, const float ir );

//! representation d'un point d'intersection.
struct Hit
{
    Hit( ) : p(), n(), color(), t(FLT_MAX), hit(false) {}
    
    Point p;    //!< position
    Vector n;   //!< normale de la surface au point d'intersection
    Color color;    //!< couleur de la surface au point d'intersection
    float t;    //!< abscisse : p= o + t.d
    bool hit;
};

#endif
