
#ifndef _BBOX_H
#define _BBOX_H

#include <cfloat>

#include "vec.h"


struct BBox
{
    BBox( ) : min( Point(FLT_MAX, FLT_MAX, FLT_MAX) ), max( Point(-FLT_MAX, -FLT_MAX, -FLT_MAX) ) {}
    BBox( const Point& p ) : min(p), max(p) {}
    BBox( const BBox& a, const BBox& b );
    
    Point min;
    Point max;
};

BBox& bbox_insert( BBox& b, const Point& p );

#endif
