
#include <algorithm>
#include <cfloat>

#include "bbox.h"


BBox::BBox( const BBox& a, const BBox& b )
{
    min.x= std::min(a.min.x, b.min.x);
    min.y= std::min(a.min.y, b.min.y);
    min.z= std::min(a.min.z, b.min.z);
    max.x= std::max(a.max.x, b.max.x);
    max.y= std::max(a.max.y, b.max.y);
    max.z= std::max(a.max.z, b.max.z);
}

BBox& bbox_insert( BBox& box, const Point& p )
{
    box.min.x= std::min(box.min.x, p.x);
    box.min.y= std::min(box.min.y, p.y);
    box.min.z= std::min(box.min.z, p.z);
    box.max.x= std::max(box.max.x, p.x);
    box.max.y= std::max(box.max.y, p.y);
    box.max.z= std::max(box.max.z, p.z);
    return box;
}
