
#include <cstdio>
#include <iostream>
#include <cstdlib>
#include <climits>

#include "NBTFile.hpp"
#include "RegionLoader.hpp"

int main(int argc, char** argv)
{
    if(argc < 2)
    {
        printf("usage: %s world\n  convert world/region/r.*.mca files\n", argv[0]);
        return 1;
    }
    
    std::vector<short> regions(16*16*16, -1);        // chuncks id   // 32x32x16
    std::vector<char> data;
    std::vector<std::string> files;
    
    try
    {
        mNBT::RegionLoader* loader;
        mNBT::Tag* temp;
        for (int x = 32; x > -32; x--)   // arbitraire, lister les regions presentes dans le repertoire
        for (int z = 32; z > -32; z--)
        {
            loader = new mNBT::RegionLoader(argv[1], x, z);
            
            // chuncks de la region; redecoupage en blocs de taille 16x16x16
            for(int x2= 0; x2 < 2; x2++)
            for(int z2= 0; z2 < 2; z2++)
            {
                // remise a zero des donnees de la region
                regions.assign(16*16*16, -1);
                data.clear();
                
                for (int x1 = 0; x1 < 16; x1++) 
                for (int z1 = 0; z1 < 16; z1++) 
                {
                    temp = loader->getChunk(x2 * 16 + x1, z2 * 16 + z1);
                    if(temp == NULL)
                        continue;
                    
                    // extraire les donnees du chunck
                    // . position
                    int xx= mNBT::NBTC<mNBT::Int>(temp->getTag(".Level.xPos"))->getPayload();
                    int zz= mNBT::NBTC<mNBT::Int>(temp->getTag(".Level.zPos"))->getPayload();
                    
                    // . sections
                    std::list<mNBT::Tag *> *sections= mNBT::NBTC<mNBT::List>(temp->getTag(".Level.Sections"))->getPayload();
                    for(std::list<mNBT::Tag *>::iterator i= sections->begin(); i != sections->end(); ++i)
                    {
                        mNBT::Tag *section= *i;
                        
                        // . type des blocks de chaque section
                        std::vector<char> *blocks= mNBT::NBTC<mNBT::ByteArray>(section->getTag("Blocks"))->getPayload();
                        
                        // teste le contenu du block, ne pas stocker les blocs vides 
                        bool empty= true;
                        for(unsigned int k= 0; k < blocks->size(); k++)
                            if((*blocks)[k])
                                empty= false;
                        
                        if(empty)
                            continue;
                        
                        // . altitude de la section
                        int y1= mNBT::NBTC<mNBT::Byte>(section->getTag("Y"))->getPayload();
                        
                        regions[y1 * 16*16 + z1 * 16 + x1]= data.size() / sizeof(char[16*16*16]);
                        
                        //~ std::cout  << "blocks " << blocks->size() << std::endl;
                        //~ std::cout  << "data " << data->size() << std::endl;
                        //~ std::cout << "region (" << x << "," << z << ")";
                        //~ std::cout << " x " << xx << " " << xx *16;
                        //~ std::cout << " y " << y1 << " " << y1 *16;
                        //~ std::cout << " z " << zz << " " << zz *16;
                        //~ std::cout << std::endl;
                        
                        data.insert(data.end(), blocks->begin(), blocks->end());
                    }
                    
                    delete temp;
                }
                
                // enregistre la region, si necessaire
                if(data.size())
                {
                    char tmp[1024];
                    sprintf(tmp, "%s/%s.%d.%d.gkmc", argv[1], argv[1], x*2 + x2, z*2 + z2);
                    printf("writing '%s'...\n", tmp);
                    FILE *file= fopen(tmp, "wb");
                    if(file == NULL)
                    {
                        printf("writing '%s'... failed.\n", tmp);
                        break;
                    }
                    
                    sprintf(tmp, "%s.%d.%d.gkmc", argv[1], x*2 + x2, z*2 + z2);
                    files.push_back(tmp);
                    
                    int size= data.size();
                    fwrite(&size, sizeof(int), 1, file);
                    fwrite(&regions.front(), sizeof(short), regions.size(), file);
                    fwrite(&data.front(), sizeof(char), data.size(), file);
                    
                    fclose(file);
                }
            }
            
            delete loader;
        }
    } 
    catch (mNBT::NBTErr error) 
    {
        std::cerr << "Error: " << error.getReason() << std::endl;
        return 1;
    }
    
    // ecrit la liste des fichiers contenant les regions exportees
    {
        char tmp[1024];
        sprintf(tmp, "%s.txt", argv[1]);
        FILE *out= fopen(tmp, "wt");
        if(out != NULL)
        {
            for(unsigned int i= 0; i < files.size(); i++)
                fprintf(out, "%s\n", files[i].c_str());
            fclose(out);
        }
    }
    
    mNBT::Tag::deleteNotchTags();
    return 0;
}
