// simple shader program
#version 330


#ifdef VERTEX_SHADER
    uniform mat4 mvpMatrix;
    uniform mat4 normalMatrix;
    
    layout (location= 0) in vec3 position;
    layout (location= 1) in vec3 normal; 
    in vec3 translation;
    
    out vec3 vertex_normal;

    void main( )
    {
        gl_Position= mvpMatrix * vec4(position + translation, 1.0);
        vertex_normal= mat3(normalMatrix) * normal;
    }
#endif

#ifdef FRAGMENT_SHADER
    uniform vec4 color;
    
    in vec3 vertex_normal;
    
    out vec4 fragment_color;

    void main( )
    {
        fragment_color= pow((1.0 - gl_FragCoord.z), .05) * color * abs(normalize(vertex_normal).z);
        //~ fragment_color= vec4(1.0, 0.1, 0.1, 1.0);
    }
#endif

