
#include "Logger.h"

#include "GL/GLBasicMesh.h"


namespace gk {

GLBasicMesh& GLBasicMesh::createBuffer( const int index, const int item_size, const GLenum item_type, 
    const unsigned int length, const void *data, const GLenum usage )
{
    if(index < 0)
        return *this;
    if(index >= (int) buffers.size())
        buffers.resize(index +1, GLBuffer::null());
    buffers[index]= gk::createBuffer(GL_ARRAY_BUFFER, length, data, usage);

#ifndef NDEBUG
    {
        GLint current;
        glGetIntegerv(GL_VERTEX_ARRAY_BINDING, &current);
        if((GLuint) current != vao->name)
            ERROR("invalid vertex array %d, basic mesh %d\n", current, vao->name);
    }
#endif
    
    glVertexAttribPointer(index, item_size, item_type, GL_FALSE, 0, NULL);
    glEnableVertexAttribArray(index);
    return *this;
}

template <> GLBasicMesh& GLBasicMesh::createBuffer( const int index, const std::vector< TVec2<float> >& data, const GLenum usage )
{
    return createBuffer(index, 2, GL_FLOAT, data.size() * sizeof(TVec2<float>), &data.front(), usage);
}

template <> GLBasicMesh& GLBasicMesh::createBuffer( const int index, const std::vector< TVec3<float> >& data, const GLenum usage )
{
    return createBuffer(index, 3, GL_FLOAT, data.size() * sizeof(TVec3<float>), &data.front(), usage);
}

template <> GLBasicMesh& GLBasicMesh::createBuffer( const int index, const std::vector< TVec4<float> >& data, const GLenum usage )
{
    return createBuffer(index, 4, GL_FLOAT, data.size() * sizeof(TVec4<float>), &data.front(), usage);
}


GLBasicMesh& GLBasicMesh::createIndexBuffer( const GLenum item_type, 
    const unsigned int length, const void *data, const GLenum usage  )
{
#ifndef NDEBUG
    {
        GLint current;
        glGetIntegerv(GL_VERTEX_ARRAY_BINDING, &current);
        if((GLuint) current != vao->name)
            ERROR("invalid vertex array %d, basic mesh %d\n", current, vao->name);
    }
#endif
    
    index_type= item_type;
    index_buffer= gk::createBuffer(GL_ELEMENT_ARRAY_BUFFER, length, data, usage);
    return *this;
}

GLBasicMesh& GLBasicMesh::createIndexBuffer( const std::vector<unsigned int>& data, const GLenum usage )
{
    return createIndexBuffer(GL_UNSIGNED_INT, data.size() * sizeof(unsigned int), &data.front(), usage);
}


int GLBasicMesh::draw( )
{
    if(primitive == -1u)
        return -1;
    
    glBindVertexArray(vao->name);
    if(index_type == 0u)
        glDrawArrays(primitive, 0, count);
    else
        glDrawElements(primitive, count, index_type, 0);

    return 0;
}

}       // namespace
