
#ifndef _GL_FRAMEBUFFER_H
#define _GL_FRAMEBUFFER_H

#include "GL/GLPlatform.h"
#include "GLResource.h"

#include "GL/GLTexture.h"


namespace gk {

//! representation d'un framebuffer opengl.
//! \ingroup OpenGL.
class GLFramebuffer : public GLResource
{
    // non copyable
    GLFramebuffer( const GLFramebuffer& );
    GLFramebuffer& operator= ( const GLFramebuffer& );
    
public:
    //! identification des buffers associees au framebuffer.
    enum 
    {
        COLOR0= 0,
        COLOR1= 1,
        COLOR2= 2,
        COLOR3= 3,
        COLOR4= 4,
        COLOR5= 5,
        COLOR6= 6,
        COLOR7= 7,
        FRAMEBUFFER_LAST_COLOR= 8,
        DEPTH= 9,
        FRAMEBUFFER_LAST= 10
    };

    //! creation des textures par le framebuffer : identification des textures a initialiser.
    enum
    {
        COLOR0_BIT= 1<<COLOR0,
        COLOR1_BIT= 1<<COLOR1,
        COLOR2_BIT= 1<<COLOR2,
        COLOR3_BIT= 1<<COLOR3,
        COLOR4_BIT= 1<<COLOR4,
        COLOR5_BIT= 1<<COLOR5,
        COLOR6_BIT= 1<<COLOR6,
        COLOR7_BIT= 1<<COLOR7,
        DEPTH_BIT= 1<<DEPTH
    };

    //! identification des drawbuffers.
    enum
    {
        DRAW0= 0,
        DRAW1= 1,
        DRAW2= 2,
        DRAW3= 3,
        DRAW4= 4,
        DRAW5= 5,
        DRAW6= 6,
        DRAW7= 7
    };
    
    std::vector<GLTexture *> buffers;
    int width;
    int height;
    
    GLFramebuffer( ) : GLResource(), buffers(FRAMEBUFFER_LAST, GLTexture::null()), width(0), height(0) {}
    GLFramebuffer( const char *_label ) : GLResource(_label), buffers(FRAMEBUFFER_LAST, GLTexture::null()), width(0), height(0) {}
    
    GLFramebuffer *create( )
    {
        assert(name == 0 && "create framebuffer error");
        glGenFramebuffers(1, &name);
        if(name == 0) 
            return this;
        
        manage();       // insere l'objet dans le manager
        return this;
    }
    
    void release( )
    {
        if(name != 0)
            glDeleteFramebuffers(1, &name);
        name= 0;
    }
    
    ~GLFramebuffer( ) {}
    
    GLFramebuffer *create( const int _width, const int _height, const unsigned int buffer_bits, 
        const TextureFormat& color_format, const TextureFormat& depth_format )
    {
        //! \todo impl
        return this;
    }
};

}       // namespace
#endif
