
#ifndef _BASIC_MESH_H
#define _BASIC_MESH_H

#include "Vec.h"
#include "GLPlatform.h"
#include "GL/GLBuffer.h"
#include "GL/GLVertexArray.h"


namespace gk {
    
class GLBasicMesh
{
    GLBasicMesh( const GLBasicMesh& );
    GLBasicMesh& operator= ( const GLBasicMesh& );
    
public:
    GLenum primitive;                   //!< type de primitive, GL_TRIANGLES, GL_TRIANGLE_STRIP, etc.
    int count;                          //!< nombre de vertex / d'indices a dessiner.
    
    GLVertexArray *vao;                 //!< vertex array object.
    std::vector<GLBuffer *> buffers;    //!< attributs : position, texcoord, normal.
    GLBuffer *index_buffer;             //!< index buffer.
    GLenum index_type;                  //!< type des indices.
    
    GLBasicMesh( const GLenum _primitive, const int _count ) 
        : 
        primitive(_primitive), count(_count), vao(createVertexArray()), buffers(), index_buffer(GLBuffer::null()), index_type(0)
    {}

    virtual ~GLBasicMesh( ) {}
    
    GLBasicMesh& createBuffer( const int index, const int item_size, const GLenum item_type, 
        const unsigned int length, const void *data, const GLenum usage= GL_STATIC_DRAW );
    
    template < typename T > GLBasicMesh& createBuffer( const int index, 
        const std::vector< TVec2<T> >& data, const GLenum usage= GL_STATIC_DRAW );
    template < typename T > GLBasicMesh& createBuffer( const int index, 
        const std::vector< TVec3<T> >& data, const GLenum usage= GL_STATIC_DRAW );
    template < typename T > GLBasicMesh& createBuffer( const int index, 
        const std::vector< TVec4<T> >& data, const GLenum usage= GL_STATIC_DRAW );
    
    GLBasicMesh& createIndexBuffer( const GLenum item_type, 
        const unsigned int length, const void *data, const GLenum usage= GL_STATIC_DRAW );
    
    GLBasicMesh& createIndexBuffer( const std::vector<unsigned int>& data, const GLenum usage= GL_STATIC_DRAW );
    
    int draw( );
};

template <> GLBasicMesh& GLBasicMesh::createBuffer( const int index, const std::vector< TVec2<float> >& data, const GLenum usage );
template <> GLBasicMesh& GLBasicMesh::createBuffer( const int index, const std::vector< TVec3<float> >& data, const GLenum usage );
template <> GLBasicMesh& GLBasicMesh::createBuffer( const int index, const std::vector< TVec4<float> >& data, const GLenum usage );

}       // namespace

#endif
