
#ifndef _GL_DEBUG_H
#define _GL_DEBUG_H

namespace gk {

namespace gkd {

struct Parameter
{
    std::string name;
    std::string value;
};

struct Draw
{
    std::string name;
    
    virtual int draw( );
    virtual int parameterCount( );
    virtual std::string parameter( const int id );
};

struct DrawArrays : public Draw
{
    GLenum mode, GLint first, GLsizei count;
    
    DrawArrays( GLenum _mode, GLint _first, GLsizei _count )
        :
        Draw(),
        mode(_mode), first(_first), count(_count)
    {}
    
    int draw( )
    {
        glDrawArrays(mode, first, count);
        // interception debug_output
        return 0;
    }
};

struct DrawElements : public Draw
{
    GLenum mode;
    GLsizei count;
    GLenum type;
    GLvoid * indices;
    
    DrawElements( GLenum _mode, GLsizei _count, GLenum _type, GLvoid * _indices )
        :
        Draw(),
        mode(_mode), count(_count), type(_type), indices(_indices)
    {}
    
    int draw( )
    {
        glDrawElements(mode, count, type, indices);
        // interception debug_output
        return 0;
    }
};

};

//! serveur
class GLDebugger
{
    GLDebugger( );
    
    // non copyable
    GLDebugger( const GLDebugger& );
    GLDebugger& operator= ( const GLDebugger& );

protected:
    int pushDraw( gkd::Draw *draw ) { m_trace.push_back(draw); }
    int beginFrame( ) {m_trace.clear(); }
    int endFrame();
    
    std::vector<gkd::Draw *> m_trace;
    
public:
    // controle de l'execution de l'application
    int nextFrame( );
    int nextDraw( );
    int play( );
    int stop( );
    
    // 
    std::string trace( );
    
    std::string draw( );
    int drawParameterCount( );
    std::string parameter drawParameter( const int parameter_id );
    
    //~ int getBufferState( );
    //~ int setVertex( );
    
    //~ int getDrawState( );
    //~ int setDrawState( );

    // construction de la trace
    int swapBuffers( )
    {
        endFrame();
        
        // stop rendering
        
        //
        beginFrame();
    }
    
    int drawArrays( GLenum mode, GLint first, GLsizei count )
    {
        pushDraw( new gkd::DrawArrays(mode, first, count) );
    }
    
    int drawElements( GLenum mode, GLsizei count, GLenum type, GLvoid * indices )
    {
        pushDraw( new gkd::DrawElements(mode, count, type, indices) );
    }
    
    static
    GLDebugger &debugger( )
    {
        GLDebugger object;
        return object;
    }
};

}       // namespace

#endif
