#version 430

#ifdef VERTEX_SHADER
uniform mat4 mvpMatrix;
uniform mat4 normalMatrix;

layout(location= 0) in vec4 position;
layout(location= 2) in vec3 normal;

out vec3 vertex_normal;

void main( )
{
    int x= gl_InstanceID % 10 - 5;
    int z= gl_InstanceID / 10 - 5;
    vec3 translate= vec3(x, 0, z) * 50.f;
    
    gl_Position= mvpMatrix * vec4(position.xyz + translate, 1.0);
    vertex_normal= mat3(normalMatrix) * normal;
}
#endif

#ifdef FRAGMENT_SHADER
layout(early_fragment_tests) in;

layout(binding= 0, r32ui) uniform uimage2D overdraw;

in vec3 vertex_normal;
out vec4 fragment_color;

void main( )
{
    imageAtomicAdd(overdraw, ivec2(gl_FragCoord.xy), 1u);
    
    fragment_color= vec4(abs(vertex_normal), 1.0);
}
#endif
