#version 330

#ifdef VERTEX_SHADER
    out vec2 vertex_texcoords;
    
    void main( )
    {
        vec3 quad[4]= vec3[4]( 
            vec3(-1, -1, 1), vec3( 1, -1, 1), 
            vec3(-1,  1, 1), vec3( 1,  1, 1));
        
        gl_Position= vec4(quad[gl_VertexID], 1.0);
        vertex_texcoords= quad[gl_VertexID].xy * 0.5 + 0.5;
    }
#endif

#ifdef FRAGMENT_SHADER
    uniform vec4 color;
    uniform mat4 lightMatrix;
    
    uniform sampler2D gbuffer0;
    uniform sampler2D gbuffer1;
    
    layout(early_fragment_tests) in;
    
    struct Light
    {
        vec4 position;      // x, y, z, radius
        vec4 emission;
    };
    
    uniform lightBuffer
    {
        Light lights[100];
    };
    
    in vec2 vertex_texcoords;
    out vec4 fragment_color;
    
    void main( )
    {
        fragment_color= vec4(0, 0, 0, 1);
	
	// retrouver les informations associees au point dans les textures gbuffer0 et gbuffer1
        vec3 normal=  texture(gbuffer1, vertex_texcoords).xyz;
	vec3 position= texture(gbuffer0, vertex_texcoords).xyz;
	
	// et calculer l'influence des sources de lumiere sur le point.
    }
#endif
    
