#version 430

#ifdef VERTEX_SHADER
void main( )
{
    vec3 quad[4]= vec3[4]( 
        vec3(-1, -1, 0), vec3( 1, -1, 0), 
        vec3(-1,  1, 0), vec3( 1,  1, 0));
    
    gl_Position= vec4(quad[gl_VertexID], 1.0);
}
#endif

#ifdef FRAGMENT_SHADER

layout(binding= 0, r32ui) uniform uimage2D overdraw;

out vec4 fragment_color;

void main( )
{
    uint count= imageLoad(overdraw, ivec2(gl_FragCoord.xy)).r;
    
    vec3 colors[10]= vec3[10](
        vec3(0,0,0), 
        vec3(12,17,115),
        vec3(28,121,255),
        vec3(31,255,255),
        vec3(130,255,17),
        vec3(255,255,14),
        vec3(255,112,22),
        vec3(251,0,20),
        vec3(113,1,14),
        vec3(113,1,14)
    );
    
    vec3 color;
    if(count < 10)
        color= colors[count] / vec3(255);
    else
        color= colors[9] / vec3(255);
    
    fragment_color= vec4(color, 1.0);
}

#endif
