
#include "App.h"
#include "Logger.h"

#include "Transform.h"

#include "IOFileManager.h"
#include "MeshIO.h"
#include "BufferManager.h"
#include "ShaderManager.h"
#include "EffectShaderManager.h"
#include "setUniform.h"


class TP : public gk::App
{
    gk::GLShaderProgram *program;
    gk::EffectShaderManager *effect;
    
public:
    // creation de la fenetre avec des reglages particuliers
    TP( )
        :
        gk::App()       // creation de l'application, mais pas du contexte opengl et de la fenetre
    {
        // parametres du contexte opengl et de la fenetre.
        gk::AppSettings settings;
        
        // creation de la fenetre et du contexte opengl
        createWindow(256, 256, settings);
    }
    
    ~TP( ) {}
    
    int init( )
    {
        //~ gk::Log::manager().setOutputFile("reload.txt");             // ecrit les messages dans le fichier texte
        //~ gk::Log::manager().setOutputLevel(gk::Log::MESSAGE);        // affiche les messages/warnings/erreurs
        //~ gk::Log::manager().setOutputLevel(gk::Log::WARNING);        // affiche les warnings/erreurs
        //~ gk::Log::manager().setOutputLevel(gk::Log::ERROR);        // affiche les erreurs
        
        // gk::MeshIO::read( mesh_filename ) pour lire un objet 3d
        // gk::createAttributeBuffer( ) pour creer un vertex buffer
        // gk::createIndexBuffer( ) pour creer un index buffer
        
        // pour creer un shader program en compilant les fichiers sources vertex et fragment
        program= gk::createShaderProgram( "vertex.vsl", "fragment.fsl" );  
        if(program == NULL || program->createGLResource() < 0)
            return -1;
        
        
        // pour un shader program decrit par un fichier .gkfx
        effect= new gk::EffectShaderManager("effect.gkfx");
        gk::GLShaderProgram *effect_program= effect->createShaderProgram("simple");
        if(effect_program == NULL || effect_program->createGLResource() < 0)
            return -1;
        
        return 0;       // tout c'est bien passe, sinon renvoyer -1
    }
    
    int quit( ) 
    {
        delete effect;
        return 0;
    }
    
    int draw( )
    {
        if(key(SDLK_ESCAPE))
            // fermer l'application si l'utilisateur appuie sur ESCAPE
            close();
        
        if(key('r'))
        {
            key('r')= 0;
            gk::IOFileManager::manager().reload(); // rescanne l'etat des fichiers 
            
            // reconfigure le shader program
            gk::reloadShaderProgram(program);   
            
            // pareil, mais recharge le fichier gkfx et reconfigure les shader programs deja compiles
            effect->reload();
        }
        
        // activer le shader
        glUseProgram(program->name());
        
        // parametrer le shader, par exemple, mvpMatrix
        
        // activer les buffers d'attributs
        // activer le buffer d'indice
        // draw
        
        // afficher le buffer de dessin
        swap();
        return 1;       // continuer
    }
};


int main( int argc, char **argv )
{
    TP app;
    app.run();
    
    return 0;
}

