
#include "App.h"

#include "Transform.h"

#include "MeshIO.h"
#include "BufferManager.h"
#include "ShaderManager.h"
#include "setUniform.h"


class TP : public gk::App
{
    gk::GLShaderProgram *program;
    
public:
    // creation de la fenetre avec les reglages par defaut.
    TP( )
        :
        gk::App(1024, 768)
    {}
    
    ~TP( ) {}
    
    int init( )
    {
        // gk::MeshIO::read( mesh_filename ) pour lire un objet 3d
        // gk::createAttributeBuffer( ) pour creer un vertex buffer
        // gk::createIndexBuffer( ) pour creer un index buffer
        // ou directement en utilisant openGL, glGenBuffers, glBindBuffer, glBufferData
        
        // pour creer un shader program en compilant les shaders a partir des fichiers sources + afficher les erreurs, si necessaire
        program= gk::createShaderProgram( "vertex.vsl", "fragment.fsl" );  
        if(program == NULL || program->createGLResource() < 0)
            return -1;
        
        return 0;       // tout c'est bien passe, sinon renvoyer -1
    }
    
    int quit( ) 
    {
        return 0;
    }
    
    int draw( )
    {
        if(key(SDLK_ESCAPE))
            // fermer l'application si l'utilisateur appuie sur ESCAPE
            close();
        
        // activer le shader
        glUseProgram(program->name());
        
        // parametrer le shader, par exemple, mvpMatrix :
        // gk::Transform mvp;
        // gk::setUniform(program->uniform("mvpMatrix"), mvp.matrix());
        
        // activer les buffers d'attributs
        // activer le buffer d'indice
        // draw
        
        // afficher le buffer de dessin
        swap();
        return 1;       // continuer
    }
};


int main( int argc, char **argv )
{
    TP app;
    app.run();
    
    return 0;
}

