solution "TP"
	configurations { "debug", "release" }
    
		local gkit_files = 
		{
			"gKit/*.cpp", "gKit/*.h",
			"gKit/GL/*.cpp", "gKit/GL/*.h",
--			"gKit/CL/*.cpp", "gKit/CL/*.h",	-- commenter si openCL n'est pas installe
			
			"gKit/Widgets/nvwidgets/nvWidgets.cpp", 
			"gKit/Widgets/nvwidgets/nvGLWidgets.cpp", 
			"gKit/Widgets/nvwidgets/nvSdlWidgets.cpp", 
			"gKit/Widgets/nvwidgets/nvSdlTextPainter.cpp",
			"gKit/Widgets/nvwidgets/nvCoreSdlWidgets.cpp", 
			"gKit/Widgets/nvwidgets/nvCoreSdlTextPainter.cpp", 
			"gKit/Widgets/nvwidgets/nvGLCoreUIPainter.cpp", 
			"gKit/Widgets/nvglutils/*.h"
		}
		
		includedirs
		{
			".",
			"gKit",
			"gKit/Widgets",
--			"/usr/local/cuda/include/"	-- include openCL nvidia	-- commenter si openCL n'est pas installe
--~ 			"/usr/local/appSDK/include/"	-- include openCL amd app
		}
		
		defines { "GK_OPENGL4", "VERBOSE" }
		defines { "NVWIDGETS_EXPORTS" } -- for nvWidgets
		
		configuration "debug"
			defines { "DEBUG" } 
			flags { "Symbols" }
		
		configuration "release"
--~ 			defines { "NDEBUG" }
			flags { "OptimizeSpeed" }
		
		configuration "linux"
			buildoptions { "-W -Wall -Wno-unused-parameter", "-pipe", "`$(PWD)/local/linux/bin/sdl2-config --cflags`", "-march=corei7" }
			
			includedirs { "$(PWD)/local/linux/include" }
			
			linkoptions { "-L$(PWD)/local/linux/lib -lGLEW" }	-- version 64 bits
			linkoptions { "-Wl,-rpath,$(PWD)/local/linux/lib" }

--~ 			linkoptions { "-L$(PWD)/local/linux/lib32 -lGLEW" }	-- version 32bits
--~ 			linkoptions { "-Wl,-rpath,$(PWD)/local/linux/lib32" }

			linkoptions { "`$(PWD)/local/linux/bin/sdl2-config --libs`" }

			includedirs { "/usr/include/OpenEXR" }
			links{ "IlmImf", "IlmThread", "Imath", "Half" }
			
			links { "SDL2_image", "SDL2_ttf" }
			links { "GLEW", "GL", "GLU" }
--			links { "OpenCL" }
		
		configuration { "linux", "release" }
			buildoptions { "-mfpmath=sse -msse3" }
--~ 			buildoptions { "-fopenmp" }
--~ 			linkoptions{ "-fopenmp" }

		configuration "windows"
			includedirs { "local/windows/include" }
			libdirs { "local/windows/lib32" }
			defines { "WIN32", "NVWIDGETS_EXPORTS", "_USE_MATH_DEFINES", "_CRT_SECURE_NO_WARNINGS" }
			defines { "NOMINMAX" } -- allow std::min() and std::max() in vc++ :(((  
			links { "opengl32", "glu32", "glew32", "SDL2", "SDL2main", "SDL2_image", "SDL2_ttf" }
		
		configuration "macosx"
			includedirs { "local/macosx/include" }
			libdirs { "local/macosx/lib" }
			defines { "APPLE_OSX", "__APPLE_CC__" }
			files
			{
				"SDLMain.m"
			}
			
			libdirs { "OpenGL.framework", "SDL.framework", "SDL_image.framework", "SDL_ttf.framework", "Cocoa.framework" }
			links { "GLEW" }
			

local project_files = {
	"shadercc",		-- compiler des shaders
	"image_viewer",		-- afficher des images hdr, png, jpg, bmp, etc.
	"mesh_viewer",		-- afficher un objet 3d
	"tessellation_tuto",	-- exemple d'utilisation de la tessellation et d'opengl4, sur un seul triangle
	"tuto_mesh",		-- exemple core profile, chargement d'un mesh et shaders position + normale 
	"tuto_shaders1",	-- exemple core profile, chargement d'un mesh, shaders de base
	"tuto_geometry"		-- exemple core profile, chargement d'un mesh, geometry shader
}

for i, name in ipairs(project_files) do
	project(name)
		language "C++"
		kind "ConsoleApp"
		files ( gkit_files )
		files { name..'.cpp' }
end

