
#ifndef _GK_PTN_TRIANGLE_H
#define _GK_PTN_TRIANGLE_H

#include "Geometry.h"
#include "Transform.h"
#include "PNTriangle.h"

namespace gk {
    
//! representation d'un triangle position + coordonnees de texture + normale.
struct PTNTriangle : public PNTriangle
{
    Point2 ta, tb, tc;
    
    //! constructeur par defaut.
    PTNTriangle( ) 
        :
        PNTriangle()
    {}
    
    //! construit un triangle connaissant ses 3 sommets, leurs normales et leurs coordonnees de textures.
    PTNTriangle( 
        const Point& _a, const Normal& _na, const Point2& _ta,
        const Point& _b, const Normal& _nb, const Point2& _tb,
        const Point& _c, const Normal& _nc, const Point2& _tc )
        :
        PNTriangle(_a, _na, _b, _nb, _c, _nc),
        ta(_ta), tb(_tb), tc(_tc)
    {}
    
    //! construit un triangle connaissant le triangle de base, les normales et les coordonnees de textures des sommets.
    PTNTriangle( const Triangle& _abc,
        const Normal& _na, const Point2& _ta,
        const Normal& _nb, const Point2& _tb,
        const Normal& _nc, const Point2& _tc )
        :
        PNTriangle(_abc, _na, _nb, _nc),
        ta(_ta), tb(_tb), tc(_tc)
    {}
    
    //! construit un triangle connaissant un pn triangle et les coordonnees de textures des sommets.
    PTNTriangle( const PNTriangle& _abc, const Point2& _ta, const Point2& _tb, const Point2& _tc )
        :
        PNTriangle(_abc),
        ta(_ta), tb(_tb), tc(_tc)
    {}
    
    //! destructeur.
    ~PTNTriangle( ) {}
    
    //! renvoie un pntriangle transforme par 't'.
    PTNTriangle transform( const Transform& t )
    {
        return PTNTriangle( 
            t(a), t(na), ta, 
            t(b), t(nb), tb, 
            t(c), t(nc), tc );
    }
    
    //! renvoie le triangle geometrique.
    Triangle getBaseTriangle( )
    {
        return Triangle(a, b, c);
    }
    
    //! renvoie le pn triangle.
    PNTriangle getPNTriangle( )
    {
        return PNTriangle(a, na, b, nb, c, nc);
    }
    
    //! calcule les coordonnees de texture d'un point a l'interieur du triangle connaissant ses coordonnees barycentriques.
    //! convention t(u, v)= (1 - u - v) * ta + u * tb + v * tc.
    Point2 getUVTexcoord( const float u, const float v ) const
    {
        const float w= 1.f - u - v;
        return ta * w + tb * u + tc * v;
    }
};

}
#endif
