
#ifndef _GLRESOURCE_H
#define _GLRESOURCE_H

#include "GL/GLPlatform.h"


namespace gk {

//! \defgroup openGL gestion des objets openGL.
//@{
    
//! classe de base des resources openGL, referencees par l'application, proprietes du contexte openGL. cf \ref GLResource, gestion des objets openGL.
class GLResource
{
    //! non copyable.
    GLResource( const GLResource& );
    //! non copyable.
    GLResource& operator=( const GLResource& );

protected:    
    GLuint m_name;
    
public:
    GLResource( )
        :
        m_name(0)
    {}
    
    virtual ~GLResource( ) {}
    
    //! comportement par defaut, necessaire pour GLManager, a redefinir dans les classes derivees.
    virtual int createGLResource( )= 0;
    
    //! comportement par defaut, necessaire pour GLManager, a redefinir dans les classes derivees.
    virtual int releaseGLResource( )= 0;
    
    //! renvoie l'identifiant de l'objet openGL.
    GLuint name( ) const
    {
        return m_name;
    }
};
// @}

} // namespace

#endif
