
#ifndef _TP_SAMPLER_H
#define _TP_SAMPLER_H

#include "GL/GLPlatform.h"
#include "GLResource.h"


namespace gk {

class GLSampler : public GLResource
{
    // non copyable
    GLSampler( const GLSampler& );
    GLSampler& operator= ( const GLSampler& );
    
public:
    GLSampler( )
        :
        GLResource()
    {
        glGenSamplers(1, &m_name);
    }

    virtual ~GLSampler( )
    {
        glDeleteSamplers(1, &m_name);
    }

    int createGLResource( )
    {
        return (m_name != 0) ? 0 : -1;
    }
    
    int releaseGLResource( )
    {
        return (m_name != 0) ? 0 : -1;
    }
};

class GLNearestSampler : public GLSampler
{
public:
    GLNearestSampler( const GLenum wrap= GL_CLAMP_TO_BORDER )
        :
        GLSampler()
    {
        if(m_name == 0)
            return;
        glSamplerParameteri(m_name, GL_TEXTURE_WRAP_S, wrap);
        glSamplerParameteri(m_name, GL_TEXTURE_WRAP_T, wrap);
        //~ glSamplerParameteri(m_name, GL_TEXTURE_MIN_FILTER, GL_NEAREST_MIPMAP_NEAREST);
        glSamplerParameteri(m_name, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
        glSamplerParameteri(m_name, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
    }
    
    ~GLNearestSampler( ) {}
};

class GLLinearSampler : public GLSampler
{
public:
    GLLinearSampler( const GLenum wrap= GL_CLAMP_TO_BORDER )
        :
        GLSampler( )
    {
        if(m_name == 0)
            return;
        glSamplerParameteri(m_name, GL_TEXTURE_WRAP_S, wrap);
        glSamplerParameteri(m_name, GL_TEXTURE_WRAP_T, wrap);
        glSamplerParameteri(m_name, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
        glSamplerParameteri(m_name, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
    }

    ~GLLinearSampler( ) {}
};

class GLAnisotropicSampler : public GLSampler
{
public:
    GLAnisotropicSampler( const float filter, const GLenum wrap= GL_CLAMP_TO_BORDER )
        :
        GLSampler( )
    {
        if(m_name == 0)
            return;
        glSamplerParameteri(m_name, GL_TEXTURE_WRAP_S, wrap);
        glSamplerParameteri(m_name, GL_TEXTURE_WRAP_T, wrap);
        glSamplerParameterf(m_name, GL_TEXTURE_MAX_ANISOTROPY_EXT, filter);
        glSamplerParameteri(m_name, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
        glSamplerParameteri(m_name, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
    }
    
    ~GLAnisotropicSampler() {}
};

class GLDepthSampler : public GLSampler
{
public:
    GLDepthSampler( const GLenum wrap= GL_CLAMP_TO_EDGE )
        :
        GLSampler()
    {
        if(m_name == 0)
            return;
        glSamplerParameteri(m_name, GL_TEXTURE_WRAP_S, wrap);
        glSamplerParameteri(m_name, GL_TEXTURE_WRAP_T, wrap);
        glSamplerParameteri(m_name, GL_TEXTURE_COMPARE_MODE, GL_NONE);
        glSamplerParameteri(m_name, GL_TEXTURE_MIN_FILTER, GL_NEAREST_MIPMAP_NEAREST);
        //~ glSamplerParameteri(m_name, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
        glSamplerParameteri(m_name, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
    }
};

}

#endif
