
#ifndef _GLSL_UNIFORMS_H
#define _GLSL_UNIFORMS_H


namespace gk {

template < typename T >
struct gvec2 
{
    T x;
    T y;
} __attribute__((aligned (8)));

template < typename T >
struct gvec3 
{
    T x;
    T y;
    T z;
} __attribute__((aligned (16)));

template < typename T >
struct gvec4 
{
    T x;
    T y;
    T z;
    T w;
} __attribute__((aligned (16)));

template < typename T >
struct gscalar
{
    T x;
    
    gscalar( const T& v )
        :
        x(v)
    {}
    
    gscalar& operator= ( const T& v )
    {
        x= v;
        return *this;
    }
    
} __attribute__((aligned (4)));

typedef gscalar<bool> GLSLbool; 
typedef gvec2<bool> GLSLbvec2;
typedef gvec3<bool> GLSLbvec3;
typedef gvec4<bool> GLSLbvec4;

typedef gscalar<unsigned int> GLSLuint;
typedef gvec2<unsigned int> GLSLuvec2;
typedef gvec3<unsigned int> GLSLuvec3;
typedef gvec4<unsigned int> GLSLuvec4;

typedef gscalar<int> GLSLint;
typedef gvec2<int> GLSLivec2;
typedef gvec3<int> GLSLivec3;
typedef gvec4<int> GLSLivec4;

typedef gscalar<float> GLSLfloat;
typedef gvec2<float> GLSLvec2;
typedef gvec3<float> GLSLvec3;
typedef gvec4<float> GLSLvec4;

}       // namespace

#endif
