
#ifndef _CL_INIT_H
#define _CL_INIT_H

#include <string>
#include <CL/CLPlatform.h>

#include "CLQueue.h"


namespace gk {

//! flags de configuration du contexte openCL
enum 
{
    CPU_BIT= 1, //!< openCL sur cpu.
    GPU_BIT= 2, //!< openCL sur gpu.
    GL_BIT= 4,  //!< openCL sur le gpu associe au contexte openGL actif.
    DEBUG_BIT= 8,       //!< compile les kernels en mode debug.
    PROFILE_BIT= 16     //!< configure la file de commande par defaut en mode profiling.
};

extern cl_platform_id ActivePlatform;
inline cl_platform_id platform( )
{
    return ActivePlatform;
}

extern cl_context ActiveContext;
extern unsigned int ActiveContextFlags;

inline cl_context context( )
{
    return ActiveContext;
}

extern cl_device_id ActiveDevice;
inline cl_device_id device( )
{
    return ActiveDevice;
}

class CLQueue;
//! renvoie la file de commande openCL par defaut.
extern CLQueue *ActiveQueue;
//! renvoie l'objet openCL associee a la file de commandes openCL creee par defaut.
inline cl_command_queue queue( )
{
    return ActiveQueue->queue();
}

extern bool Active;
inline bool isCLInit( )
{
    return Active;
}

//! initialise un contexte et un peripherique openCL.
int CLInit( const unsigned int flags= GPU_BIT );
//! ferme le contexte openCL.
void CLQuit( void );

extern std::string ActiveBuildOptions;
//! ajoute une option de compilation commune a tous les kernels compiles.
int CLBuildOptions( const std::string& options );

class CLQueue;
//! cree une file de commande openCL.
CLQueue *createQueue( );

}

#endif
