
#include <cstdio>

#include "CLInit.h"
#include "CLError.h"
#include "CLBuffer.h"
#include "CLManager.h"


namespace gk {
    
CLBuffer::CLBuffer( const cl_mem_flags flags, const unsigned int glname )
    :
    CLResource(),
    m_buffer(0),
    m_size(0)
{
    cl_int status;
    m_buffer= clCreateFromGLBuffer(ActiveContext, flags, glname, &status );
    if(status != CL_SUCCESS || m_buffer == 0)
    {
        printf("error creating CLBuffer from openGL buffer: %s\n", CLError(status));
        m_buffer= 0;
        return;
    }
    
    // a verifier, recuperer la taille du buffer 
}

CLBuffer::CLBuffer( const cl_mem_flags flags, const size_t size, void *data )
    :
    CLResource(),
    m_buffer(0),
    m_size(size)
{
    if(size == 0)
    {
        printf("CLBuffer( ): empty buffer.\nfailed.\n");
        return;
    }
    
    cl_int status;
    m_buffer= clCreateBuffer(ActiveContext, flags, size, data, &status );
    if(status != CL_SUCCESS)
    {
        printf("CLBuffer( ): error: %s.\n", CLError(status));
        m_buffer= 0;
        m_size= 0;
        return;
    }
}
    
int CLBuffer::createCLResource( )
{
    return (m_buffer != 0) ? 0 : -1;
}

int CLBuffer::releaseCLResource( )
{
    if(m_buffer == 0)
        return -1;
    
    clReleaseMemObject(m_buffer);
    m_buffer= 0;
    return 0;
}

int CLBuffer::update( size_t offset, size_t length, const void *data, cl_bool block, cl_event *wait )
{
    if(m_buffer == 0 || ActiveQueue == NULL)
        return -1;
    
    cl_int status= clEnqueueWriteBuffer(ActiveQueue->queue(), m_buffer, block, offset, length, data, 0, NULL, wait);
    if(status != CL_SUCCESS)
        printf("CLBuffer::update(%lu, %lu): error. %s.\n", offset, length, CLError(status));
    return (status == CL_SUCCESS) ? 0 : -1;
}

int CLBuffer::get( size_t offset, size_t length, void *data, cl_bool block, cl_event *wait )
{
    if(m_buffer == 0 || ActiveQueue == NULL)
        return -1;
    
    cl_int status= clEnqueueReadBuffer(ActiveQueue->queue(), m_buffer, block, offset, length, data, 0, NULL, wait);
    if(status != CL_SUCCESS)
        printf("CLBuffer::get(%lu, %lu): error. %s.\n", offset, length, CLError(status));
    return (status == CL_SUCCESS) ? 0 : -1;
}


CLBuffer *createBuffer( const cl_mem_flags flags, const size_t size, void *data )
{
    return CLManager<CLBuffer>::manager().insert( 
        new CLBuffer(flags, size, data) );
}

CLBuffer *createReadBuffer( const size_t size, void *data )
{
    cl_mem_flags flags= CL_MEM_READ_ONLY;
    if(data != NULL)
        flags= flags | CL_MEM_COPY_HOST_PTR;
    return createBuffer(flags, size, data);
}

CLBuffer *createWriteBuffer( const size_t size )
{
    cl_mem_flags flags= CL_MEM_WRITE_ONLY;
    return createBuffer(flags, size, NULL);
}

CLBuffer *createGLObjectBuffer( const cl_mem_flags flags, const unsigned int glname )
{
    return CLManager<CLBuffer>::manager().insert( 
        new CLBuffer(flags, glname) );
}

}
