
#include "App.h"

#include "Geometry.h"
#include "Transform.h"

#include "BufferManager.h"
#include "ShaderManager.h"
#include "setUniform.h"


class TP : public gk::App
{
    GLuint m_vertex_array;
    GLuint m_position_buffer;
    
    gk::GLShaderProgram *m_program;
    
public:
    // creation du contexte openGL et d'une fenetre
    TP( )
        :
        gk::App(),
        m_vertex_array(0),
        m_position_buffer(0),
        m_program(NULL)
    {
        // specifie le type de contexte openGL a creer :
        gk::AppSettings settings;
        settings.setGLVersion(3,3);     // version 3.3
        settings.setGLCoreProfile();      // core profile
        settings.setGLDebugContext();     // version debug pour obtenir les messages d'erreur en cas de probleme
        
        // cree le contexte et une fenetre de dimensions 1024x768
        createWindow(1280, 768, settings);      
    }
    
    ~TP( ) {}
    
    int init( )
    {
        // initialisation : construire l'ensemble des positions des sommets des triangles a dessiner 
        std::vector<gk::Point> positions;
        {
            // ... a remplir
        }

        // etape 1 :
        // cree un buffer pour stocker les positions des sommets
        glGenBuffers(1, &m_position_buffer);
        // active le buffer
        glBindBuffer(GL_ARRAY_BUFFER, m_position_buffer);
        // transfere les donnees et dimensionne le buffer
        glBufferData(GL_ARRAY_BUFFER, positions.size() * sizeof(gk::Point), &positions.front(), GL_STATIC_DRAW);
        
        // cree un shader program en compilant les shaders a partir des fichiers sources + afficher les erreurs de compilation, etc., si necessaire
        //~ m_program= gk::createShaderProgram( "vertex_color.vsl", "fragment_color.fsl" );  
        m_program= gk::createShaderProgram( "vertex.vsl", "fragment.fsl" );  
        if(m_program == NULL || m_program->createGLResource() < 0)
            return -1;
        
        // etape 1 : 
        // cree un vertex array pour conserver l'association entre les buffers et les attributs de sommets necessaires a l'execution du vertex shader
        glGenVertexArrays(1, &m_vertex_array);
        // active le vertex array
        glBindVertexArray(m_vertex_array);
        
        // etape 2 :
        // recupere l'identifiant de l'attribut declare dans le vertex shader
        GLint attribut= m_program->attribute("position");
        
        // associe le contenu du buffer courant a l'attribut de sommets necessaire a l'execution du vertex shader
        // le buffer courant est le dernier active sur GL_ARRAY_BUFFER, dans ce cas m_position_buffer
        glVertexAttribPointer(attribut, 3, GL_FLOAT, GL_FALSE, 0, 0);
        glEnableVertexAttribArray(attribut);
        
        // nettoyage, desactive les differents objets selectionnes
        glBindVertexArray(0);
        glBindBuffer(GL_ARRAY_BUFFER, 0);
        
        return 0;       // tout c'est bien passe, sinon renvoyer -1
    }
    
    int quit( ) 
    {
        // detruire les objets openGL crees dans init()
        glDeleteBuffers(1, &m_position_buffer);
        glDeleteVertexArrays(1, &m_vertex_array);
        
        // le shader program et les shaders sont detruits automatiquement par gKit.
        return 0;
    }
    
    int draw( )
    {
        if(key(SDLK_ESCAPE))
            // fermer l'application si l'utilisateur appuie sur ESCAPE
            close();
        
        // fixer la transformation viewport en fonction des dimensions de la fenetre
        glViewport(0, 0, windowWidth(), windowHeight());
        // effacer l'image
        glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
        
        // activer le shader
        glUseProgram(m_program->name());
        
        // parametrer le shader, par exemple, la composition des transformations, mvpMatrix :
        //~ gk::Transform mvp;
        // mvp= xxx
        //~ gk::setUniform(m_program->uniform("mvpMatrix"), mvp.matrix());

        // parametrer le shader, par exemple, une couleur :
        //~ gk::Color color(1.0f, 1.0f, 0.0f);
        //~ gk::setUniform(m_program->uniform("color"), color);
        
        // selectionner / activer le vertex array configure dans init( )
        glBindVertexArray(m_vertex_array);
        
        // dessiner l'objet
        //~ glDrawXXX();
        
        // nettoyage, desactive les differents objets selectionnes
        glUseProgram(0);
        glBindVertexArray(0);
        
        // afficher le buffer de dessin
        swap();
        return 1;       // continuer, dessiner une autre fois l'image, renvoyer 0 pour arreter l'application
    }
};


int main( int argc, char **argv )
{
    TP app;
    app.run();
    
    return 0;
}

