
#include "GL/TPProgramName.h"
#include "setUniform.h"


namespace gk {
    
int setUniform( const ProgramUniform& uniform, const Point& point )
{
    return setUniform(uniform, point.x, point.y, point.z);
}
    
int setUniform( const ProgramUniform& uniform, const Point2& point )
{
    return setUniform(uniform, point.x, point.y);
}

int setUniform( const ProgramUniform& uniform, const Vector& vector )
{
    return setUniform(uniform, vector.x, vector.y, vector.z);
}

int setUniform( const ProgramUniform& uniform, const Normal& vector )
{
    return setUniform(uniform, vector.x, vector.y, vector.z);
}

int setUniform( const ProgramUniform& uniform, const Color& color)
{
    return setUniform(uniform, color.r, color.g, color.b, color.a);
}

int setUniform( const ProgramUniform& uniform, const Transform& transform )
{
    return setUniform(uniform, transform.matrix(), GL_TRUE);
}

int setUniform( const ProgramUniform& uniform, const Matrix4x4& transform )
{
    return setUniform(uniform, transform, GL_TRUE);
}

}
