
// mailto:jean-claude.iehl@liris.cnrs.fr
// provides SDL_ttf text rendering for nvWidgets


#ifndef NV_SDL_TEXT_PAINTER_H
#define NV_SDL_TEXT_PAINTER_H

#include <string>

#include <GL/glew.h>
#ifdef __APPLE_CC__
#include <OpenGL/gl.h>
#include <SDL_ttf/SDL_ttf.h>
#elif defined WIN32
	#include <GL/gl.h>
    #include <SDL.h>
	#include <SDL_ttf.h>
#else
    #include <GL/gl.h>
    #include <SDL2/SDL.h>
    #include <SDL2/SDL_ttf.h>
#endif

#include "nvTextPainter.h"


namespace nv {

struct SdlTextGlyph
{
    float tex_xmin, tex_xmax;
    float tex_ymin, tex_ymax;
    int xmin, xmax;
    int ymin, ymax;
    int advance;
};

class NVSDKENTRY SdlTextPainter : public TextPainter
{
protected:
    std::string m_name;
    int m_point_size;
    int m_line_skip;
    int m_height;
    int m_ascent;
    bool m_is_init;

    GLuint m_texture;
    SdlTextGlyph m_cache[128];
    
    virtual void draw_glyph( const int x, const int y, const int id );
    SDL_Surface *init_glyph_cache( );
    
public:
    SdlTextPainter( const std::string& filename, const int size );
    virtual ~SdlTextPainter( );

    int getFontHeight( ) const;
    int getTextLineWidth( const char * text ) const;
    int getTextLineWidthAt( const char * text, int charNb ) const;
    int getTextSize( const char * text, int& nbLines ) const;
    int getPickedCharNb( const char * text, const nv::Point& at ) const;

    virtual void init( );
    virtual void begin( const Rect& window );
    virtual void end( );
    
    //~ void drawCharacter( int x, int y, const char c );
    virtual void drawString( int x, int y, const char *c, int nbLines, int colorId, const float *color );
};

}

#endif
