#ifndef NV_GL3_WIDGETS_H
#define NV_GL3_WIDGETS_H

#include <cassert>

#include "nvGLWidgets.h"
#include "nvGLCoreDraw.h"


namespace nv {
namespace GLCore {

struct widget_program
{
    GLuint program;     //!< required, shader program name
    GLint projection;   //!< required, projection matrix uniform location
    
    GLint fillColor;    //!< additional uniform locations
    GLint borderColor;
    GLint zones;
    
    widget_program( )
        :
        program(0),
        projection(-1),
        fillColor(-1),
        borderColor(-1),
        zones(-1)
    {}
};

struct texture_program
{
    GLuint program;     //!< required, shader program name
    GLint projection;   //!< required, projection matrix uniform location
    
    texture_program( )
        :
        program(0),
        projection(-1)
    {}
};

struct widget_params : public params
{
    const widget_program *program;
    
    int borderId;
    int fillId;
    
    vec4 border;
    vec4 fill;
    vec2 zones;
    
    widget_params( const widget_program& _program )
        :
        params(),
        program(&_program),
        borderId(0),
        fillId(0)
    {}
    
    void apply( )
    {
        assert(program != NULL);
        assert(program->fillColor > -1);
        assert(program->borderColor > -1);
        assert(program->zones > -1);
        glUniform4fv(program->fillColor, 1, fill);
        glUniform4fv(program->borderColor, 1, border);
        glUniform2fv(program->zones, 1, zones);
    }
};

}       // namespace GLCore


// core profile painter
// \todo refactor GLUIPainter to remove duplicate drawing code GLUIPainter =UILayout + GLPainter / GLCorePainter ?
class GLCoreUIPainter : public GLUIPainter
{
public:
    GLCoreUIPainter( TextPainter& textPainter );
    ~GLCoreUIPainter( );
    
    void init();
    void begin( const Rect& window );
    void end();

    // Draw primitive shapes
    //~ void drawText( const Rect& r , const char * text, int nbLines = 1, int caretPos = -1, bool isHover = false, bool isOn = false, bool isFocus = false );
    //~ void drawFrame( const Rect& rect, const Point& corner, bool isHover = false, bool isOn = false, bool isFocus = false );
    //~ void drawBoolFrame( const Rect& rect, const Point& corner, bool isHover = false, bool isOn = false, bool isFocus = false );

    void drawString( int x, int y, const char * text, int nbLines, int colorId, const float *color );
    void drawRect( const Rect& rect, int fillColorId, int borderColorId );
    void drawRoundedRect( const Rect& rect, const Point& corner, int fillColorId, int borderColorId );
    void drawRoundedRectOutline( const Rect& rect, const Point& corner, int borderColorId );
    void drawCircle( const Rect& rect, int fillColorId, int borderColorId );
    void drawMinus( const Rect& rect, int width, int fillColorId, int borderColorId );
    void drawPlus( const Rect& rect, int width, int fillColorId, int borderColorId );
    void drawDownArrow( const Rect& rect, int width, int fillColorId, int borderColorId );
    void drawUpArrow( const Rect& rect, int width, int fillColorId, int borderColorId );

    
protected:
    nv::GLCore::widget_program m_widget_program;
    nv::GLCore::Draw<nv::GLCore::widget_params> m_widgets;
};

}
#endif
