// mailto:jean-claude.iehl@liris.cnrs.fr
// provides SDL_ttf text rendering for nvWidgets, core profile

#ifndef CORE_SDL_TEXT_PAINTER_H
#define CORE_SDL_TEXT_PAINTER_H

#include <cassert>

#include "nvSdlTextPainter.h"
#include "nvGLCoreDraw.h"


namespace nv {

namespace GLCore {

struct text_program
{
    GLuint program;     //!< required, shader program name
    GLint projection;   //!< required, projection matrix uniform location
    
    GLint font;
    GLint color;
    
    text_program( )
        :
        program(0),
        projection(-1),
        font(-1),
        color(-1)
    {}
};

struct text_params : public params
{
    const text_program *program;
    
    int colorId;
    vec4 color;
    int font;
    
    text_params( const text_program& _program )
        :
        params(),
        program(&_program),
        colorId(0),
        color(1.f, 1.f, 1.f, 1.f),
        font(0)
    {}
    
    void apply( )
    {
        assert(program != NULL);
        assert(program->color > -1);
        assert(program->font > -1);
        glUniform4fv(program->color, 1, color);
        glUniform1i(program->font, font);   //!< sampler, texture unit 0
    }
};

}       // namespace GLCore


class NVSDKENTRY CoreSdlTextPainter : public SdlTextPainter
{
public:
    CoreSdlTextPainter( const std::string& filename, const int size );
    ~CoreSdlTextPainter( );

protected:
    void init( );
    void begin( const Rect& window );
    void end( );
    
    void draw_glyph( const int x, const int y, const int id );
    //~ void drawCharacter( int x, int y, const char c );
    void drawString( int x, int y, const char *c, int nbLines, int colorId, const float *color );

    GLuint m_sampler;
    GLCore::text_program m_text_program;
    GLCore::Draw<GLCore::text_params> m_texts;
};

}       // namespace nv

#endif

