
#ifndef _GKTEXTURE_MANAGER_H
#define _GKTEXTURE_MANAGER_H

#include "GLManager.h"
#include "GL/GLPlatform.h"
#include "GL/TPTexture.h"


namespace gk {

//! \ingroup openGL
//@{

//! gestion 'auto' des ressources openGL : pour les textures couleurs.
inline
GLTexture2D *createTexture2D( const int unit, const int w, const int h, const TextureFormat& format= TextureRGBA )
{
    return GLManager<GLTexture2D>::manager().insert( 
        new GLTexture2D(unit, w, h, format) );
}

//! gestion 'auto' des ressources openGL : pour les textures couleurs.
inline
GLTexture2D *createTexture2D( const int unit, const HDRImage *image, const TextureFormat& format= TextureRGBA32F )
{
    return GLManager<GLTexture2D>::manager().insert(
        new GLTexture2D(unit, image, format) );
}

//! gestion 'auto' des ressources openGL : pour les textures couleurs.
inline
GLTexture2D *createTexture2D( const int unit, const Image *image, const TextureFormat& format= TextureRGBA )
{
    return GLManager<GLTexture2D>::manager().insert(
        new GLTexture2D(unit, image, format) );
}

//! gestion 'auto' des ressources openGL : pour les textures profondeur.
inline
GLDepthTexture *createDepthTexture( const int unit, const int w, const int h, const TextureFormat& format= TextureDepth )
{
    return GLManager<GLDepthTexture>::manager().insert(
        new GLDepthTexture(unit, w, h, format) );
}

    
//! gestion 'auto' des ressources openGL : pour les tableaux de textures 2d.
inline
GLTexture2DArray *createTexture2DArray( const int unit, const int w, const int h, const int count, const TextureFormat& format= TextureRGBA )
{
    return GLManager<GLTexture2DArray>::manager().insert(
        new GLTexture2DArray(unit, w, h, count, format) );
}

//! gestion 'auto' des ressources openGL : pour les tableaux de textures 2d.
inline
GLTexture2DArray *createTexture2DArray( const int unit, const HDRImageArray *images, const TextureFormat& format= TextureRGBA32F )
{
    return GLManager<GLTexture2DArray>::manager().insert(
        new GLTexture2DArray(unit, images, format) );
}
    
//! gestion 'auto' des ressources openGL : pour les tableaux de textures 2d.
inline
GLTexture2DArray *createTexture2DArray( const int unit, const ImageArray *images, const TextureFormat& format= TextureRGBA )
{
    return GLManager<GLTexture2DArray>::manager().insert(
        new GLTexture2DArray(unit, images, format) );
}

//! \todo other types of textures declared in GL/TPTexture.h

//@}
}

#endif
