
#ifndef _GKSAMPLER_MANAGER_H
#define _GKSAMPLER_MANAGER_H

#include "GLManager.h"
#include "GL/GLPlatform.h"
#include "GL/TPSampler.h"


namespace gk {

//! \ingroup openGL
//@{
    
//! gestion 'auto' des ressources openGL : pour les samplers de textures (mipmap linear).
inline
GLSampler *createSampler( const GLenum wrap= GL_CLAMP_TO_BORDER )
{
    return GLManager<GLSampler>::manager().insert( 
        new GLLinearSampler(wrap) );
}

//! gestion 'auto' des ressources openGL : pour les samplers de textures (mipmap linear).
inline
GLSampler *createLinearSampler( const GLenum wrap= GL_CLAMP_TO_BORDER )
{
    return GLManager<GLSampler>::manager().insert( 
        new GLLinearSampler(wrap) );
}

//! gestion 'auto' des ressources openGL : pour les samplers de textures (anisotropic).
inline
GLSampler *createAnisotropicSampler( const float filter= 4, const GLenum wrap= GL_CLAMP_TO_BORDER )
{
    return GLManager<GLSampler>::manager().insert( 
        new GLAnisotropicSampler(filter, wrap) );
}

//! gestion 'auto' des ressources openGL : pour les samplers de textures (nearest).
inline
GLSampler *createNearestSampler( const GLenum wrap= GL_CLAMP_TO_BORDER )
{
    return GLManager<GLSampler>::manager().insert( 
        new GLNearestSampler(wrap) );
}

//! gestion 'auto' des ressources openGL : pour les samplers de textures depth component.
inline
GLSampler *createDepthSampler( const GLenum wrap= GL_CLAMP_TO_BORDER )
{
    return GLManager<GLSampler>::manager().insert( 
        new GLDepthSampler(wrap) );
}

//@}

}

#endif
