
#ifndef _SAMPLER_H
#define _SAMPLER_H

#include <cstdlib>
#include <time.h>


namespace gk {

#ifdef WIN32    
//! representation d'un generateur aleatoire ... simpliste, voire inutile
class Sampler
{
public:
    Sampler( ) {}
    
    //! genere un reel entre 0 et 1.
    float uniformFloat( )
    {
        return (float) rand() / (float) RAND_MAX;
    }
    
    //! genere un entier entre 0 et max.
    int uniformInt( const int max )
    {
        return ((float) rand() * (float) max / (float) RAND_MAX) + .5f;
    }
    
    //! initialisation du germe du generateur aleatoire.
    static void init( const int seed= 0 )
    {
        if(seed != 0)
            srand(seed);
        else
            srand(time(NULL));
    }
};

#else
//! representation d'un generateur aleatoire ... simpliste, voire inutile
class Sampler
{
public:
    Sampler( ) {}
    
    //! genere un reel entre 0 et 1.
    float uniformFloat( )
    {
        return drand48();
    }
    
    //! genere un entier entre 0 et max.
    int uniformInt( const int max )
    {
        return (drand48() * (float) max + .5f);
    }
    
    //! initialisation du germe du generateur aleatoire.
    static void init( const int seed= 0 )
    {
        if(seed != 0)
            srand48(seed);
        else
            srand48(time(NULL));
    }
};

#endif
}

#endif
