
#ifndef _GK_PN_TRIANGLE_H
#define _GK_PN_TRIANGLE_H

#include "Geometry.h"
#include "Transform.h"
#include "Triangle.h"

namespace gk {
    
//! representation d'un triangle position + normale.
struct PNTriangle : public Triangle
{
    Normal na, nb, nc;
    
    //! constructeur par defaut.
    PNTriangle( ) 
        :
        Triangle()
    {}
    
    //! construit un triangle connaissant ses 3 sommets et leur normales.
    PNTriangle( 
        const Point& _a, const Normal& _na, 
        const Point& _b, const Normal& _nb,
        const Point& _c, const Normal& _nc )
        :
        Triangle(_a, _b, _c),
        na(_na), nb(_nb), nc(_nc)
    {}
    
    //! construit un triangle connaissant le triangle de base et les normales des sommets.
    PNTriangle( const Triangle& abc,
        const Normal& _na, const Normal& _nb, const Normal& _nc )
        :
        Triangle(abc),
        na(_na), nb(_nb), nc(_nc)
    {}
    
    //! destructeur.
    ~PNTriangle( ) {}
    
    //! calcule la normale a l'interieur du triangle connaissant ses coordonnees barycentriques.
    //! convention n(u, v)= (1 - u - v) * na + u * nb + v * nc.
    Normal getUVNormal( const float u, const float v ) const
    {
        const float w= 1.f - u - v;
        return Normalize(na * w + nb * u + nc * v);
    }
    
    //! renvoie un pntriangle transforme par 't'.
    PNTriangle transform( const Transform& t )
    {
        return PNTriangle( t(a), t(na), t(b), t(nb), t(c), t(nc) );
    }
    
    //! renvoie le triangle geometrique support du PN triangle.
    Triangle getBaseTriangle( )
    {
        return Triangle(a, b, c);
    }
};

}
#endif
