
#ifndef _IMAGE_ARRAY_H
#define _IMAGE_ARRAY_H

#include <vector>

#include "Image.h"


namespace gk {

template< class T >
class TImageArray
{
    TImageArray( );
    TImageArray( const TImageArray& );
    TImageArray& operator= ( const TImageArray& );
    
protected:
    std::vector< TImage<T> *> m_images;
    unsigned int m_width;
    unsigned int m_height;
    
    int isValid( TImage<T> *image )
    {
        if(image == NULL)
            return -1;
        if(m_images.size() == 0)
        {
            m_width= image->width();
            m_height= image->height();
            return 0;
        }
        
        return (image->width() == m_width && image->height() == m_height) ? 0 : -1;
    }
    

public:
    TImageArray( const unsigned int count= 1 )
        :
        m_images(),
        m_width(0),
        m_height(0)
    {
        m_images.reserve(count);
    }

    virtual ~TImageArray( ) {}

    unsigned int width( ) const
    {
        return m_width;
    }
    
    unsigned int height( ) const
    {
        return m_height;
    }
    
    unsigned int size( ) const
    {
        return m_images.size();
    }
    
    void clear( )
    {
        m_images.clear();
    }
    
    int push_back( TImage<T> *image )
    {
        if(isValid(image) < 0)
            return -1;
        m_images.push_back(image);
        return 0;
    }
    
    int push_back( TImage<T>& image )
    {
        if(isValid(&image) < 0)
            return -1;
        m_images.push_back(&image);
        return 0;
    }
    
    const TImage<T> *operator[] ( const unsigned int index ) const
    {
        if(index >= (unsigned int) m_images.size())
            return NULL;
        
        return m_images[index];
    }
    
    TImage<T> * &operator[] ( const unsigned int index )
    {
        assert(index < (unsigned int) m_images.size());
        return m_images[index];
    }
};

//! declaration d'un image array hdr, pixels rgba.
typedef TImageArray<HDRPixel> HDRImageArray;
//! declaration d'un image array, pixels rgba.
typedef TImageArray<Pixel> ImageArray;

template< class T >
class TImageCube : public TImageArray<T>
{
public:
    TImageCube( )
        :
        TImageArray<T>(6)
    {}
    
    ~TImageCube( ) {}
    
    const TImage<T> *operator[] ( const unsigned int face ) const
    {
        if(face < GL_TEXTURE_CUBE_MAP_POSITIVE_X)       //dependence opengl
            return TImageArray<T>::operator[](face);
        if(face <= GL_TEXTURE_CUBE_MAP_NEGATIVE_Z)
            return TImageArray<T>::operator[](face - GL_TEXTURE_CUBE_MAP_POSITIVE_X);
        assert(0);
    }
    
    TImage<T> * &operator[] ( const unsigned int face )
    {
        if(face < GL_TEXTURE_CUBE_MAP_POSITIVE_X)       //dependence opengl
            return TImageArray<T>::operator[](face);
        if(face <= GL_TEXTURE_CUBE_MAP_NEGATIVE_Z)
            return TImageArray<T>::operator[](face - GL_TEXTURE_CUBE_MAP_POSITIVE_X);
        assert(0);
    }
};

//! declaration d'une image cube hdr, pixels rgba.
typedef TImageCube<HDRPixel> HDRImageCube;
//! declaration d'une image cube, pixels rgba.
typedef TImageCube<Pixel> ImageCube;

}

#endif
