
#ifndef _IORESOURCE_H
#define _IORESOURCE_H

#include <cassert>

#include "IOFileManager.h"


namespace gk {

//! utilisation interne. nom + infos pour un objet importe par un IOManager.
class IOName
{
    IOFileInfo m_handle;
    std::string m_name;

public:
    //! constructeur par defaut.
    IOName( )
        :
        m_handle(),
        m_name()
    {}
    
    //! constructeur, descripteur du fichier et nom de la ressource.
    IOName( const IOFileInfo& handle, const std::string& name )
        :
        m_handle(handle),
        m_name(name)
    {}
    
    ~IOName( ) {}
    
    //! necessaire pour l'insertion dans une std::map, comparaison sur le nom uniquement.
    bool operator<( const IOName& b ) const
    {
        assert(m_handle.file != NULL);
        assert(b.m_handle.file != NULL);
        
        const int cmp= m_handle.file->filename.compare(b.m_handle.file->filename);
        if(cmp < 0)
            return true;
        else if(cmp > 0)
            return false;
        return (m_name < b.m_name);
    }
    
    //! renvoie le nom du fichier associe a la ressource.
    const std::string& filename( ) const
    {
        return m_handle.filename();
    }
    
    //! renvoie le nom de l'objet associe a la ressource.
    const std::string name( ) const
    {
        return m_name;
    }
    
    //! renvoie le descripteur de fichier associe a la ressource.
    IOFileInfo& handle( )
    {
        return m_handle;
    }
};


//! classe de base des resources importees depuis un fichier, referencees par l'application, proprietes du gk::IOManager.
class IOResource
{
    // non copyable
    IOResource( const IOResource& );
    IOResource& operator=( const IOResource& );

public:
    IOResource( ) {}
    
    virtual ~IOResource( ) {}
};

} // namespace

#endif
