
#ifndef _GLSHADERIO_H
#define _GLSHADERIO_H

#include "IOManager.h"
#include "TextFileIO.h"
#include "GL/GLShaderObject.h"


namespace gk {

template< class Shader >
class TShaderIO : public IOManager<Shader>
{
    // non copyable
    TShaderIO( const TShaderIO& );
    TShaderIO& operator=( const TShaderIO& );
    
    // private default constructor, singleton
    TShaderIO( )
        :
        IOManager<Shader>()
    {}
    
    ~TShaderIO( )
    {
        // detruire les ressources GL, ~IOManager() detruit les objets.
        for(typename std::map<IOName, Shader *>::iterator 
            i= IOManager<Shader>::m_names_map.begin(); 
            i != IOManager<Shader>::m_names_map.end(); ++i)
            i->second->releaseGLResource();
    }
    
public:
    //! importe le shader 'name' a partir du ficher 'filename'
    static
    Shader *read( const std::string& filename, const std::string& name= "" ) 
    {
        // importer le fichier, si necessaire
        Shader *shader= manager().find(filename, name);
        if(shader != NULL)
            return shader;
        
        // cree le shader directement' sans utiliser GLManager / GLContext, l'objet ne doit etre gere que par un seul manager !!
        TextFile *source= TextFileIO::read(filename);
        if(source == NULL)
            return NULL;
        
        shader= new Shader();
        if(shader->pushSource(source) < 0)
        {
            delete shader;
            return NULL;
        }
        
        // reference le shader avec le manager
        return manager().insert(shader, filename, name);
    }

    static
    TShaderIO<Shader>& manager( )  // singleton
    {
        static TShaderIO<Shader> manager;
        return manager;
    }
};

typedef TShaderIO<GLVertexShader> GLVertexShaderIO;
typedef TShaderIO<GLFragmentShader> GLFragmentShaderIO;

#if defined GK_OPENGL3 || defined GK_OPENGL4
typedef TShaderIO<GLGeometryShader> GLGeometryShaderIO;
#endif

#ifdef GK_OPENGL4
typedef TShaderIO<GLControlShader> GLControlShaderIO;
typedef TShaderIO<GLEvaluationShader> GLEvaluationShaderIO;
#endif

}       // namespace

#endif

