
#include "CLInit.h"
#include "CLQueue.h"
#include "CLKernel.h"
#include "CLError.h"


namespace gk {
    
CLQueue::CLQueue( const cl_command_queue_properties flags )
    :
    CLResource(),
    m_queue(0)
{
    cl_int status;
    m_queue= clCreateCommandQueue(ActiveContext, ActiveDevice, flags, &status);
    if(status != CL_SUCCESS)
        m_queue= 0;
}

CLQueue::~CLQueue( )  {}

int CLQueue::createCLResource( )
{
    return (m_queue == 0) ? 0 : -1;
}

int CLQueue::releaseCLResource( )
{
    if(m_queue == 0)
        return -1;
    
    clReleaseCommandQueue(m_queue);
    m_queue= 0;
    return 0;
}

int CLQueue::dispatch( CLKernel *kernel, const size_t global_size, const size_t group_size, cl_event *wait )
{
    if(m_queue == 0)
        return -1;
    
    cl_int status= clEnqueueNDRangeKernel(m_queue, kernel->kernel(), 
        1, NULL, &global_size, &group_size, 0, NULL, wait);

    if(status != CL_SUCCESS)
        printf("dispatch error: %s\n", CLError(status));
    return (status == CL_SUCCESS) ? 0 : -1;
}

int CLQueue::dispatch2D( CLKernel *kernel, const size_t global_width, const size_t global_height, const size_t group_width, const size_t group_height, cl_event *wait  )
{
    if(m_queue == 0)
        return -1;
    
    size_t global_size[2]= { global_width, global_height };
    size_t group_size[2]= { group_width, group_height };
    
    cl_int status= clEnqueueNDRangeKernel(m_queue, kernel->kernel(), 
        2, NULL, global_size, group_size, 0, NULL, wait);

    if(status != CL_SUCCESS)
        printf("dispatch error: %s\n", CLError(status));
    return (status == CL_SUCCESS) ? 0 : -1;
}
    
int CLQueue::dispatch3D( CLKernel *kernel, cl_event *wait )
{
    if(m_queue == 0)
        return -1;
    
    printf("dispatch3D( ): not implemented.\n");
    return -1;
}

}
