
#ifndef _CL_KERNEL_H
#define _CL_KERNEL_H

#include <string>
#include <CL/CLPlatform.h>

#include "CLInit.h"
#include "CLResource.h"


namespace gk {

class CLBuffer;
class CLImage;
class TextFile;
    
class CLKernel : public CLResource
{
    cl_program m_program;
    cl_kernel m_kernel;
    cl_uint m_parameter_count;
    
    CLKernel( CLKernel& );
    CLKernel& operator= ( const CLKernel& );
    
    std::string m_name;
    std::string m_options;
    TextFile *m_source;
    int make( const TextFile *source, const std::string& name, const std::string& options );
    
public:
    CLKernel( )
        :
        m_program(0),
        m_kernel(0),
        m_parameter_count(0),
        m_name(),
        m_options(),
        m_source(NULL)
    {}
    
    CLKernel( TextFile *source, const std::string& name, const std::string& options= "" )
        :
        m_program(0),
        m_kernel(0),
        m_parameter_count(0),
        m_name(name),
        m_options(options),
        m_source(source)
    {}
    
    ~CLKernel( ) {}

    int define( const std::string& what, const std::string& value );
    int options( const std::string& options );
    
    int createCLResource( );
    int releaseCLResource( );
    
    const std::string& name( ) const
    {
        return m_name;
    }
        
    const cl_kernel *object( ) const
    {
        return &m_kernel;
    }
    
    cl_kernel *object( )
    {
        return &m_kernel;
    }
    
    cl_kernel kernel( ) const
    {
        return m_kernel;
    }
    
    int parameterCount( )
    {
        return m_parameter_count;
    }
    
    int setParameter( const unsigned int index, const size_t size, const void *value );
    int setParameter( const unsigned int index, const CLBuffer *buffer );
    int setParameter( const unsigned int index, const CLImage *image );
    
    size_t workgroupSize( );
    size_t scheduleSize( );
    size_t CompileWorkgroupSize( );	// declaredSize ?
    size_t CompileWorkgroupSizes( size_t sizes[3] );
    
    size_t localMemorySize( );
    size_t privateMemorySize( );
};

CLKernel *createKernel( const std::string& filename, const std::string& name, const std::string& options= "" );

int dispatch( CLKernel *kernel, const size_t global_size, const size_t group_size, cl_event *wait= NULL );
int dispatch2D( CLKernel *kernel, const size_t global_width, const size_t global_height, const size_t group_width, const size_t group_height, cl_event *wait= NULL );
int dispatch3D( CLKernel *kernel, cl_event *wait= NULL );

}       // namespace gk

#endif
