solution "TP"
	configurations { "debug", "release" }
    
		local gkit = 
		{
			"gKit/*.cpp", "gKit/*.h",
			"gKit/GL/*.cpp", "gKit/GL/*.h",
			
			"gKit/Widgets/nvwidgets/nvWidgets.cpp", "gKit/Widgets/nvwidgets/nvGLWidgets.cpp", 
			"gKit/Widgets/nvwidgets/nvSdlWidgets.cpp", "gKit/Widgets/nvwidgets/nvSdlTextPainter.cpp",
			"gKit/Widgets/nvglutils/*.h",
		}
		
		includedirs
		{
			".",
			"gKit",
			"gKit/Widgets"
		}
		
		configuration "debug"
			defines { "DEBUG", "VERBOSE" } 
--~ 			"GK_OPENGL4",
			flags { "ExtraWarnings", "Symbols" }
		
		configuration "release"
			defines { "NDEBUG", "VERBOSE" }
--~ 			"GK_OPENGL4", 
			flags { "Optimize" }
		
		configuration "linux"
			includedirs { "glew-1.7.0/include" }
			buildoptions { "-pipe", "`sdl-config --cflags`", "-march=native" }
			linkoptions { "-Wl,-rpath,glew-1.7.0/lib -Lglew-1.7.0/lib -lGLEW" } -- forcer la version locale de GLEW
			linkoptions { "`sdl-config --libs`" }
			links { "GL", "SDL_image", "SDL_ttf" }
		
		configuration { "linux", "release" }
			buildoptions { "-march=native -mfpmath=sse -msse3" }
--~ 		-funsafe-math-optimizations -ffinite-math-only -fno-signed-zeros -fno-trapping-math -mrecip -ftree-vectorize 

		configuration "windows"
			includedirs { } -- configurer les libs dans visual
			defines { "WIN32", "NVWIDGETS_EXPORTS", "_USE_MATH_DEFINES", "_CRT_SECURE_NO_WARNINGS" }
			defines { "NOMINMAX" } -- allow std::min() and std::max() in vc++ :(((  
			defines { "NVWIDGETS_EXPORTS" } -- for gKitStatic lib
			links { "opengl32", "glu32", "glew32", "SDL", "SDLmain", "SDL_image", "SDL_ttf" }
		
		configuration "macosx"
			defines { "APPLE_OSX", "__APPLE_CC__"}
			files
			{
				"SDLMain.m"
			}
			buildoptions {"-framework OpenGL -framework SDL -framework SDL_image -framework SDL_ttf -framework Cocoa -I$HOME/local/include"}
			linkoptions {"-framework OpenGL -framework SDL -framework SDL_image -framework SDL_ttf -framework Cocoa -L$HOME/local/lib"}
			links {"GLEW", "RGBE"}
		

--~ construction de la librairie statique
project "gKitStatic"
	language "C++"
	kind "StaticLib"
	files(gkit)

--~ construction de la librairie dynamique
project "gKitShared"
 	language "C++"
 	kind "SharedLib"
 	files(gkit)
	
	configuration "linux"
		buildoptions {"-fPIC"}


--~ liste des projets / programmes a construire, en utilisant la librairie gKit
local projets = {
	"image_viewer",
	"tuto1",
	"tuto2",
	"tuto3",
	"tuto4",
	"subdivide_main",
	"mesh_viewer"
}

--~  construit la description des projets a partir de liste
for i, name in ipairs(projets) do
	project(name)
		language "C++"
		kind "ConsoleApp"
		links {"gKitShared"}
		files {name..'.cpp'}
		
		configuration "linux"
			linkoptions { "-Wl,-rpath,. -L." }	-- indiquer ou trouver la librairie dynamique
end

