
#include "Transform.h"
#include "Geometry.h"
#include "Sampler.h"
#include "PNTriangle.h"
#include "Image.h"
#include "ImageIO.h"
#include "Mesh.h"
#include "MeshIO.h"


bool transform( gk::Point& q, const gk::Point& p, const gk::Transform& mvp, const gk::Transform& viewport )
{
    gk::HPoint h;
    // projette le point
    mvp(p, h);
    q= viewport(h.project());

    // verifie que le point est visible
    return h.isVisible();
}

void draw( gk::Image *image, gk::TImage<float> *zbuffer, const gk::PNTriangle& triangle, const gk::Transform& mvp, const gk::Transform& viewport )
{
    // transforme les sommets du triangle
    gk::Point qa, qb, qc;
    bool va= transform(qa, triangle.a, mvp, viewport);
    bool vb= transform(qb, triangle.b, mvp, viewport);
    bool vc= transform(qc, triangle.c, mvp, viewport);

    // determine le nombre de sudivision le long de chaque arete,
    // et le nombre maximum de subdivisions pour les 2 aretes de chaque sommet.
    float ra= 1.f;
    if(va && vb)
        ra= gk::Vector(qa, qb).Length();
    if(va && vc)
        ra= std::max(ra, gk::Vector(qa, qc).Length());
    
    float rb= 1.f;
    if(vb && va)
        rb= gk::Vector(qb, qa).Length();
    if(vb && vc)
        rb= std::max(rb, gk::Vector(qb, qc).Length());
    
    // echantillonne chaque arete, trace une ligne dans le domaine parametrique parallele a chaque arete
    ra= ra * sqrtf(2.f);
    rb= rb * sqrtf(2.f);
    for(int i= 0; i < (int) (ra + .5f); i++)
    {
        float w= (float) i / ra;
        if(w > 1.f)
            w= 1.f;
        
        for(int k= 0; k < (int) (rb + .5f); k++)
        {
            float u= (float) k / rb;
            if(u > 1.f)
                u= 1.f;
            float v= 1 - u - w;
            if(v < 0.f)
                continue;
            
            gk::Point q;
            gk::Point p= triangle.getUVPoint(u, v);
            if(transform(q, p, mvp, viewport))
            {
                // teste la visibilite
                if(q.z < zbuffer->getPixel(q.x, q.y))
                {
                    // modifie le z buffer
                    zbuffer->setPixel(q.x, q.y, q.z);
                    
                    // recupere la normale
                    gk::Normal n= triangle.getUVNormal(u, v);
                    //~ n= (n + gk::Normal(1.f, 1.f, 1.f)) * .5f * 255.f;
                    float v= n.z * 255.f;
                    if(v < 0.f)
                        v= 0.f;
                    image->setPixel(q.x, q.y, gk::Pixel(v, v, v));
                    
                    //~ // compte le nombre de fragments se projettant sur ce pixel
                    //~ gk::Pixel pixel= image->getPixel(q.x, q.y);
                    //~ image->setPixel(q.x, q.y, gk::Pixel(std::min(255, (int) pixel.r +1), 0, 0));
                }
            }
        }
    }
}


int main( int argc, char **argv )
{
    // cree l'image resultat
    gk::Image *image= new gk::Image(1024, 768);
    assert(image != NULL);
    
    gk::TImage<float> *zbuffer= new gk::TImage<float>(image->width(), image->height());
    assert(zbuffer != NULL);
    // initialise le zbuffer 
    for(int y= 0; y < zbuffer->height(); y++)
        for(int x= 0; x < zbuffer->width(); x++)
            zbuffer->setPixel(x, y, 1.f);
    
    // charge un objet
    gk::Mesh *mesh= gk::MeshIO::read("bigguy.obj");
    if(mesh == NULL)
        return 1;

    // definit les transformations
    gk::Transform model;
    gk::Transform view= gk::Translate( gk::Vector(0.f, 0.f, -50.f) );
    gk::Transform projection= gk::Perspective(50.f, 1.f, 1.f, 1000.f);
    gk::Transform viewport= gk::Viewport(image->width(), image->height());
    
    // compose la transformation complete
    gk::Transform mvp= projection * view * model;

    // recupere les triangles de la surface de l'objet
    int count= mesh->triangleCount();
    for(int i= 0; i < count; i++)
    {
        const gk::PNTriangle& triangle= mesh->getPNTriangle(i);
        draw(image, zbuffer, triangle, mvp, viewport);
    }

    // enregistre le resultat.
    gk::ImageIO::write(image, "output.bmp");
    return 0;
}
