
#include "Transform.h"
#include "Geometry.h"
#include "Sampler.h"
#include "PNTriangle.h"
#include "Image.h"
#include "ImageIO.h"
#include "Mesh.h"
#include "MeshIO.h"


bool transform( gk::Point& q, const gk::Point& p, const gk::Transform& mvp, const gk::Transform& viewport )
{
    gk::HPoint h;
    // projette le point
    mvp(p, h);
    
    // verifie que le point est visible
    if(h.isCulled())
        return false;
    
    // si le point est visible, finir la transformation
    q= viewport(h.project());
    return true;
}


// declare un generateur de nombres aleatoires ... global, accessible par toutes les fonctions
static gk::Sampler sampler;

void sample( gk::Image *image, const gk::PNTriangle& triangle, const gk::Transform& mvp, const gk::Transform& viewport )
{
    // genere 20 points aleatoirement a l'interieur du triangle
    for(int i= 0; i < 20; i++)
    {
        // genere un point aleatoire a l'interieur du triangle
        gk::Point p;
        triangle.sampleUniform(sampler, p);
        
        // transforme le point 
        gk::Point q;
        if(transform(q, p, mvp, viewport))
            image->setPixel( q.x, q.y, gk::Pixel(255, 255, 0) );
    }
}


int main( int argc, char **argv )
{
    // initialise le generateur de nombre aleatoire
    gk::Sampler::init(0);

    // cree l'image resultat
    gk::Image *image= new gk::Image(1024, 1024);

    // charge un objet
    gk::Mesh *mesh= gk::MeshIO::read("bigguy.obj");
    if(mesh == NULL)
        return 1;
    
    // definit les transformations
    gk::Transform model;
    gk::Transform view= gk::Translate( gk::Vector(0.f, 0.f, -50.f) );
    gk::Transform projection= gk::Perspective(50.f, 1.f, 1.f, 1000.f);
    gk::Transform viewport= gk::Viewport(image->width(), image->height());
    
    // compose la transformation complete
    gk::Transform mvp= projection * view * model;
    
    // recupere les triangles de la surface de l'objet
    int count= mesh->triangleCount();
    for(int i= 0; i < count; i++)
    {
        const gk::PNTriangle& triangle= mesh->getPNTriangle(i);
        sample(image, triangle, mvp, viewport);
    }
    
    // enregistre le resultat.
    gk::ImageIO::write(image, "output.bmp");
    return 0;
}
