
#include "Transform.h"
#include "Geometry.h"
#include "PNTriangle.h"
#include "Image.h"
#include "ImageIO.h"
#include "Mesh.h"
#include "MeshIO.h"

bool transform( gk::Point& q, const gk::Point& p, const gk::Transform& mvp, const gk::Transform& viewport )
{
    gk::HPoint h;
    // projette le point
    mvp(p, h);
    
    // verifie que le point est visible
    if(h.isCulled())
        return false;
    
    // si le point est visible, finir la transformation
    q= viewport(h.project());
    return true;
}


int main( int argc, char **argv )
{
    // cree l'image resultat
    gk::Image *image= new gk::Image(1024, 1024);

    // charge un objet
    gk::Mesh *mesh= gk::MeshIO::read("bigguy.obj");
    if(mesh == NULL)
        return 1;
    
    // definit les transformations
    gk::Transform model;
    gk::Transform view= gk::Translate( gk::Vector(0.f, 0.f, -50.f) );
    gk::Transform projection= gk::Perspective(50.f, 1.f, 1.f, 1000.f);
    gk::Transform viewport= gk::Viewport(image->width(), image->height());
    
    // compose la transformation complete
    gk::Transform mvp= projection * view * model;
    
    // recupere les triangles de la surface de l'objet
    int count= mesh->triangleCount();
    for(int i= 0; i < count; i++)
    {
        const gk::PNTriangle& triangle= mesh->getPNTriangle(i);
        
        gk::Point q;
        if(transform(q, triangle.a, mvp, viewport))
            image->setPixel( q.x, q.y, gk::Pixel(255, 255, 0) );
        if(transform(q, triangle.b, mvp, viewport))
            image->setPixel( q.x, q.y, gk::Pixel(255, 255, 0) );
        if(transform(q, triangle.c, mvp, viewport))
            image->setPixel( q.x, q.y, gk::Pixel(255, 255, 0) );
    }
    
    // enregistre le resultat.
    gk::ImageIO::write(image, "output.bmp");
    return 0;
}
