
#ifndef _GK_PN_TRIANGLE_H
#define _GK_PN_TRIANGLE_H

#include "Geometry.h"
#include "Transform.h"
#include "Triangle.h"

namespace gk {
    
//! representation d'un triangle 'geometrique'.
struct PNTriangle : public Triangle
{
    Normal na, nb, nc;
    
    //! constructeur par defaut.
    PNTriangle( ) 
        :
        Triangle()
    {}
    
    //! construit un triangle connaissant ses 3 sommets.
    PNTriangle( 
        const Point& _a, const Normal& _na, 
        const Point& _b, const Normal& _nb,
        const Point& _c, const Normal& _nc )
        :
        Triangle(_a, _b, _c),
        na(_na), nb(_nb), nc(_nc)
    {}
    
    //! destructeur.
    ~PNTriangle( ) {}
    
    //! renvoie un pntriangle transforme par 't'.
    PNTriangle transform( const Transform& t )
    {
        return PNTriangle( t(a), t(na), t(b), t(nb), t(c), t(nc) );
    }
    
    //! renvoie le triangle geoemtrique
    Triangle getBaseTriangle( )
    {
        return Triangle(a, b, c);
    }
};

}
#endif
